/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.blocks;

import forestry.core.blocks.BlockBase;
import forestry.core.tiles.TileUtil;
import forestry.energy.EnergyHelper;
import forestry.energy.ForestryEnergyStorage;
import forestry.energy.blocks.EngineBlockType;
import forestry.energy.tiles.EngineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EngineBlock
extends BlockBase<EngineBlockType> {
    private static final VoxelShape[] SHAPE_FOR_DIRECTIONS = new VoxelShape[6];
    public static final EnumProperty<Direction> VERTICAL_FACING = EnumProperty.m_61598_((String)"facing", Direction.class, (Enum[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN, Direction.UP});

    public EngineBlock(EngineBlockType blockType) {
        super(blockType, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(VERTICAL_FACING, (Comparable)Direction.UP));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{VERTICAL_FACING});
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        Direction orientation = (Direction)state.m_61143_(VERTICAL_FACING);
        return SHAPE_FOR_DIRECTIONS[orientation.ordinal()];
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rot) {
        return EngineBlock.rotate(state, world, pos);
    }

    private static boolean isOrientedAtEnergyReciever(LevelAccessor world, BlockPos pos, Direction orientation) {
        BlockPos offsetPos = pos.m_121945_(orientation);
        BlockEntity tile = TileUtil.getTile((BlockGetter)world, offsetPos);
        return EnergyHelper.isEnergyReceiverOrEngine(orientation.m_122424_(), tile);
    }

    private static BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction blockFacing = (Direction)state.m_61143_(VERTICAL_FACING);
        for (int i = blockFacing.ordinal() + 1; i <= blockFacing.ordinal() + 6; ++i) {
            Direction orientation = Direction.f_122346_[i % 6];
            if (!EngineBlock.isOrientedAtEnergyReciever(world, pos, orientation)) continue;
            return (BlockState)state.m_61124_(VERTICAL_FACING, (Comparable)orientation);
        }
        return state;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Direction orientation = context.m_43719_().m_122424_();
        Level world = context.m_43725_();
        if (EngineBlock.isOrientedAtEnergyReciever((LevelAccessor)world, pos = context.m_8083_(), orientation)) {
            return (BlockState)this.m_49966_().m_61124_(VERTICAL_FACING, (Comparable)orientation);
        }
        return EngineBlock.rotate((BlockState)this.m_49966_().m_61124_(VERTICAL_FACING, (Comparable)context.m_8125_()), (LevelAccessor)world, pos);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        EngineBlockEntity tileEngine = TileUtil.getTile((BlockGetter)level, pos, EngineBlockEntity.class);
        if (tileEngine != null) {
            ForestryEnergyStorage energyStorage = tileEngine.getEnergyManager();
            return energyStorage.calculateRedstone();
        }
        return 0;
    }

    static {
        EngineBlock.SHAPE_FOR_DIRECTIONS[Direction.EAST.ordinal()] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)14.0), Block.m_49796_((double)10.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)});
        EngineBlock.SHAPE_FOR_DIRECTIONS[Direction.WEST.ordinal()] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)14.0), Block.m_49796_((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        EngineBlock.SHAPE_FOR_DIRECTIONS[Direction.SOUTH.ordinal()] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)2.0, (double)6.0, (double)14.0, (double)14.0, (double)10.0), Block.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)16.0)});
        EngineBlock.SHAPE_FOR_DIRECTIONS[Direction.NORTH.ordinal()] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)2.0, (double)6.0, (double)14.0, (double)14.0, (double)10.0), Block.m_49796_((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0)});
        EngineBlock.SHAPE_FOR_DIRECTIONS[Direction.UP.ordinal()] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)});
        EngineBlock.SHAPE_FOR_DIRECTIONS[Direction.DOWN.ordinal()] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0)});
    }
}

