/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.ForestryConstants;
import forestry.api.client.IForestryClientApi;
import forestry.api.core.IErrorLogicSource;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.energy.tiles.EngineBlockEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class EngineScreen<M extends AbstractContainerMenu, E extends EngineBlockEntity>
extends GuiForestryTitled<M> {
    protected final E engine;

    public EngineScreen(String texture, M menu, Inventory inv, Component title, E engine) {
        super(texture, menu, inv, title);
        this.engine = engine;
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger((IErrorLogicSource)this.engine);
        this.addHintLedger(((EngineBlockEntity)this.engine).getHintKey());
        this.ledgerManager.add(new EngineLedger<E>(this.ledgerManager, this.engine));
    }

    protected static class EngineLedger<E extends EngineBlockEntity>
    extends Ledger {
        private final E engine;

        public EngineLedger(LedgerManager manager, E engine) {
            super(manager, "power");
            this.engine = engine;
            this.maxHeight = 94;
        }

        @Override
        public void draw(PoseStack transform, int y, int x) {
            this.drawBackground(transform, y, x);
            this.drawSprite(transform, IForestryClientApi.INSTANCE.getTextureManager().getSprite(ForestryConstants.forestry("misc/energy")), x + 3, y + 4);
            if (this.isFullyOpened()) {
                this.drawHeader(transform, (Component)Component.m_237115_((String)"for.gui.energy"), x + 22, y + 8);
                this.drawSubheader(transform, (Component)Component.m_237115_((String)"for.gui.currentOutput").m_130946_(":"), x + 22, y + 20);
                this.drawText(transform, GuiUtil.formatRate(((EngineBlockEntity)this.engine).getCurrentOutput()), x + 22, y + 32);
                this.drawSubheader(transform, (Component)Component.m_237115_((String)"for.gui.stored").m_130946_(":"), x + 22, y + 44);
                this.drawText(transform, GuiUtil.formatEnergyValue(((EngineBlockEntity)this.engine).getEnergyManager().getEnergyStored()), x + 22, y + 56);
                this.drawSubheader(transform, (Component)Component.m_237115_((String)"for.gui.heat").m_130946_(":"), x + 22, y + 68);
                this.drawText(transform, (double)((EngineBlockEntity)this.engine).getHeat() / 10.0 + 20.0 + " C", x + 22, y + 80);
            }
        }

        @Override
        public Component getTooltip() {
            return Component.m_237115_((String)GuiUtil.formatRate(((EngineBlockEntity)this.engine).getCurrentOutput()));
        }
    }
}

