/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.utils.RecipeUtils;
import forestry.core.utils.SlotUtil;
import forestry.factory.tiles.TileCarpenter;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class InventoryCarpenter
extends InventoryAdapterTile<TileCarpenter> {
    public static final int SLOT_BOX = 9;
    public static final int SLOT_PRODUCT = 10;
    public static final int SLOT_PRODUCT_COUNT = 1;
    public static final int SLOT_CAN_INPUT = 11;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;

    public InventoryCarpenter(TileCarpenter carpenter) {
        super(carpenter, 30, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        if (slotIndex == 11) {
            Optional fluid = FluidUtil.getFluidContained((ItemStack)stack);
            return fluid.map(f -> ((TileCarpenter)this.tile).getTankManager().canFillFluidType((FluidStack)f)).orElse(false);
        }
        if (slotIndex == 9) {
            return RecipeUtils.isCarpenterBox(((TileCarpenter)this.tile).m_58904_().m_7465_(), stack);
        }
        if (this.canSlotAccept(11, stack) || this.canSlotAccept(9, stack)) {
            return false;
        }
        return SlotUtil.isSlotInRange(slotIndex, 12, 18);
    }

    @Override
    public boolean m_7157_(int slotIndex, ItemStack itemstack, Direction side) {
        return slotIndex == 10;
    }
}

