/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BottlerRecipe {
    public final FluidStack fluid;
    public final ItemStack inputStack;
    public final ItemStack outputStack;
    public final boolean fillRecipe;

    @Nullable
    public static BottlerRecipe createEmptyingRecipe(ItemStack filled) {
        ItemStack empty = filled.m_41777_();
        empty.m_41764_(1);
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)empty);
        if (!fluidHandlerCap.isPresent()) {
            return null;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)fluidHandlerCap.orElse(null);
        FluidStack drained = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
        if (!drained.isEmpty() && drained.getAmount() > 0) {
            return new BottlerRecipe(fluidHandler.getContainer(), drained, filled, false);
        }
        return null;
    }

    @Nullable
    public static BottlerRecipe createFillingRecipe(Fluid res, ItemStack empty) {
        ItemStack filled = empty.m_41777_();
        filled.m_41764_(1);
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)filled);
        if (!fluidHandlerCap.isPresent()) {
            return null;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)fluidHandlerCap.orElse(null);
        int fillAmount = fluidHandler.fill(new FluidStack(res, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE);
        if (fillAmount > 0) {
            return new BottlerRecipe(empty, new FluidStack(res, fillAmount), fluidHandler.getContainer(), true);
        }
        return null;
    }

    public BottlerRecipe(ItemStack inputStack, FluidStack fluid, ItemStack outputStack, boolean fillRecipe) {
        this.fluid = fluid;
        this.inputStack = inputStack;
        this.outputStack = outputStack;
        this.fillRecipe = fillRecipe;
    }

    public boolean matchEmpty(ItemStack emptyCan, FluidStack resource) {
        return !emptyCan.m_41619_() && emptyCan.m_41656_(this.inputStack) && resource.isFluidEqual(this.fluid) && this.fillRecipe;
    }

    public boolean matchFilled(ItemStack filledCan) {
        return !this.outputStack.m_41619_() && !this.fillRecipe && this.outputStack.m_41656_(filledCan);
    }
}

