/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.FakeCraftingInventory;
import forestry.factory.recipes.RecipeSerializers;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class CarpenterRecipe
implements ICarpenterRecipe {
    private final ResourceLocation id;
    private final int packagingTime;
    private final FluidStack liquid;
    private final Ingredient box;
    private final CraftingRecipe recipe;
    private final ItemStack result;

    public CarpenterRecipe(ResourceLocation id, int packagingTime, FluidStack liquid, Ingredient box, CraftingRecipe recipe, @Nullable ItemStack result) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)box);
        Preconditions.checkNotNull((Object)recipe);
        this.id = id;
        this.packagingTime = packagingTime;
        this.liquid = liquid;
        this.box = box;
        this.recipe = recipe;
        this.result = result != null ? result : recipe.m_8043_();
    }

    @Override
    public int getPackagingTime() {
        return this.packagingTime;
    }

    @Override
    public Ingredient getBox() {
        return this.box;
    }

    @Override
    public FluidStack getInputFluid() {
        return this.liquid;
    }

    @Override
    public CraftingRecipe getCraftingGridRecipe() {
        return this.recipe;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    @Override
    public boolean matches(FluidStack fluid, ItemStack boxStack, Container craftingInventory, Level level) {
        FluidStack liquid = this.liquid;
        if (!(liquid.isEmpty() || !fluid.isEmpty() && fluid.containsFluid(liquid))) {
            return false;
        }
        Ingredient box = this.box;
        if (!box.m_43947_() && !box.test(boxStack)) {
            return false;
        }
        return this.recipe.m_5818_((Container)FakeCraftingInventory.of(craftingInventory), level);
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return FactoryRecipeTypes.CARPENTER.serializer();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return FactoryRecipeTypes.CARPENTER.type();
    }

    public static class Serializer
    implements RecipeSerializer<CarpenterRecipe> {
        public CarpenterRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int packagingTime = GsonHelper.m_13927_((JsonObject)json, (String)"time");
            FluidStack liquid = json.has("liquid") ? RecipeSerializers.deserializeFluid(GsonHelper.m_13930_((JsonObject)json, (String)"liquid")) : FluidStack.EMPTY;
            Ingredient box = RecipeSerializers.deserialize(json.get("box"));
            CraftingRecipe internal = (CraftingRecipe)RecipeManager.m_44045_((ResourceLocation)recipeId, (JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"recipe"));
            ItemStack result = json.has("result") ? RecipeSerializers.item(GsonHelper.m_13930_((JsonObject)json, (String)"result")) : internal.m_8043_();
            return new CarpenterRecipe(recipeId, packagingTime, liquid, box, internal, result);
        }

        public CarpenterRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int packagingTime = buffer.m_130242_();
            FluidStack liquid = buffer.readBoolean() ? FluidStack.readFromPacket((FriendlyByteBuf)buffer) : FluidStack.EMPTY;
            Ingredient box = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            CraftingRecipe internal = (CraftingRecipe)ClientboundUpdateRecipesPacket.m_133647_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            return new CarpenterRecipe(recipeId, packagingTime, liquid, box, internal, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, CarpenterRecipe recipe) {
            buffer.m_130130_(recipe.packagingTime);
            if (!recipe.liquid.isEmpty()) {
                buffer.writeBoolean(true);
                recipe.liquid.writeToPacket(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            recipe.box.m_43923_(buffer);
            ClientboundUpdateRecipesPacket.m_179469_((FriendlyByteBuf)buffer, (Recipe)recipe.recipe);
            buffer.m_130055_(recipe.result);
        }
    }
}

