/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.FakeCraftingInventory;
import forestry.factory.recipes.RecipeSerializers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorRecipe
implements IFabricatorRecipe {
    private final ResourceLocation id;
    private final Ingredient plan;
    private final FluidStack resultFluid;
    private final ShapedRecipe recipe;

    public FabricatorRecipe(ResourceLocation id, Ingredient plan, FluidStack resultFluid, ShapedRecipe recipe) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)plan);
        Preconditions.checkNotNull((Object)resultFluid);
        this.id = id;
        this.plan = plan;
        this.resultFluid = resultFluid;
        this.recipe = recipe;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public Ingredient getPlan() {
        return this.plan;
    }

    @Override
    public FluidStack getResultFluid() {
        return this.resultFluid;
    }

    @Override
    public ShapedRecipe getCraftingGridRecipe() {
        return this.recipe;
    }

    @Override
    public boolean matches(Level level, FluidStack liquid, ItemStack stack, Container inventory) {
        return liquid.containsFluid(this.resultFluid) && this.plan.test(stack) && this.recipe.m_5818_(FakeCraftingInventory.of(inventory), level);
    }

    public ItemStack m_8043_() {
        return this.recipe.m_8043_();
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return FactoryRecipeTypes.FABRICATOR.serializer();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return FactoryRecipeTypes.FABRICATOR.type();
    }

    public static class Serializer
    implements RecipeSerializer<FabricatorRecipe> {
        public FabricatorRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient plan = RecipeSerializers.deserialize(json.get("plan"));
            FluidStack molten = RecipeSerializers.deserializeFluid(GsonHelper.m_13930_((JsonObject)json, (String)"molten"));
            ShapedRecipe internal = (ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(recipeId, GsonHelper.m_13930_((JsonObject)json, (String)"recipe"));
            return new FabricatorRecipe(recipeId, plan, molten, internal);
        }

        public FabricatorRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient plan = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidStack molten = buffer.readFluidStack();
            ShapedRecipe internal = (ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(recipeId, buffer);
            return new FabricatorRecipe(recipeId, plan, molten, internal);
        }

        public void toNetwork(FriendlyByteBuf buffer, FabricatorRecipe recipe) {
            recipe.getPlan().m_43923_(buffer);
            buffer.writeFluidStack(recipe.getResultFluid());
            RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)recipe.getCraftingGridRecipe());
        }
    }
}

