/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.IFermenterRecipe;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FermenterRecipe
implements IFermenterRecipe {
    private final ResourceLocation id;
    private final Ingredient resource;
    private final int fermentationValue;
    private final float modifier;
    private final Fluid output;
    private final FluidStack fluidResource;

    public FermenterRecipe(ResourceLocation id, Ingredient resource, int fermentationValue, float modifier, Fluid output, FluidStack fluidResource) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)resource, (Object)"Fermenter Resource cannot be null!");
        Preconditions.checkArgument((!resource.m_43947_() ? 1 : 0) != 0, (Object)"Fermenter Resource item cannot be empty!");
        Preconditions.checkNotNull((Object)output, (Object)"Fermenter Output cannot be null!");
        Preconditions.checkNotNull((Object)fluidResource, (Object)"Fermenter Liquid cannot be null!");
        this.id = id;
        this.resource = resource;
        this.fermentationValue = fermentationValue;
        this.modifier = modifier;
        this.output = output;
        this.fluidResource = fluidResource;
    }

    public FermenterRecipe(ResourceLocation id, int fermentationValue, float modifier, Fluid output, FluidStack fluidResource) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)output, (Object)"Fermenter output cannot be null!");
        Preconditions.checkNotNull((Object)fluidResource, (Object)"Fermenter liquid cannot be null!");
        this.id = id;
        this.resource = Ingredient.f_43901_;
        this.fermentationValue = fermentationValue;
        this.modifier = modifier;
        this.output = output;
        this.fluidResource = fluidResource;
    }

    @Override
    public Ingredient getInputItem() {
        return this.resource;
    }

    @Override
    public FluidStack getInputFluid() {
        return this.fluidResource;
    }

    @Override
    public int getFermentationValue() {
        return this.fermentationValue;
    }

    @Override
    public float getModifier() {
        return this.modifier;
    }

    @Override
    public Fluid getOutput() {
        return this.output;
    }

    @Override
    public boolean matches(ItemStack inputItem, FluidStack inputFluid) {
        return this.resource.test(inputItem) && this.fluidResource.isFluidEqual(inputFluid);
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return FactoryRecipeTypes.FERMENTER.serializer();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return FactoryRecipeTypes.FERMENTER.type();
    }

    public static class Serializer
    implements RecipeSerializer<FermenterRecipe> {
        public FermenterRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient resource = RecipeSerializers.deserialize(json.get("resource"));
            int fermentationValue = GsonHelper.m_13927_((JsonObject)json, (String)"fermentationValue");
            float modifier = GsonHelper.m_13915_((JsonObject)json, (String)"modifier");
            Fluid output = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"output")));
            FluidStack fluidResource = RecipeSerializers.deserializeFluid(GsonHelper.m_13930_((JsonObject)json, (String)"fluidResource"));
            return new FermenterRecipe(recipeId, resource, fermentationValue, modifier, output, fluidResource);
        }

        public FermenterRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient resource = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int fermentationValue = buffer.m_130242_();
            float modifier = buffer.readFloat();
            Fluid output = (Fluid)ForgeRegistries.FLUIDS.getValue(buffer.m_130281_());
            FluidStack fluidResource = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            return new FermenterRecipe(recipeId, resource, fermentationValue, modifier, output, fluidResource);
        }

        public void toNetwork(FriendlyByteBuf buffer, FermenterRecipe recipe) {
            recipe.resource.m_43923_(buffer);
            buffer.m_130130_(recipe.fermentationValue);
            buffer.writeFloat(recipe.modifier);
            buffer.m_130085_(ForgeRegistries.FLUIDS.getKey((Object)recipe.output));
            recipe.fluidResource.writeToPacket(buffer);
        }
    }
}

