/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.ISqueezerContainerRecipe;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;

public class SqueezerContainerRecipe
implements ISqueezerContainerRecipe {
    private final ResourceLocation id;
    private final ItemStack emptyContainer;
    private final int processingTime;
    private final ItemStack remnants;
    private final float remnantsChance;

    public SqueezerContainerRecipe(ResourceLocation id, ItemStack emptyContainer, int processingTime, ItemStack remnants, float remnantsChance) {
        this.id = id;
        Preconditions.checkNotNull((Object)emptyContainer);
        Preconditions.checkArgument((!emptyContainer.m_41619_() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)remnants);
        this.emptyContainer = emptyContainer;
        this.processingTime = processingTime;
        this.remnants = remnants;
        this.remnantsChance = remnantsChance;
    }

    @Override
    public ItemStack getEmptyContainer() {
        return this.emptyContainer;
    }

    @Override
    public List<Ingredient> getInputs() {
        return List.of();
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public ItemStack getRemnants() {
        return this.remnants;
    }

    @Override
    public float getRemnantsChance() {
        return this.remnantsChance;
    }

    @Override
    public FluidStack getFluidOutput() {
        return FluidStack.EMPTY;
    }

    public ItemStack m_8043_() {
        return this.remnants;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return FactoryRecipeTypes.SQUEEZER_CONTAINER.serializer();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return FactoryRecipeTypes.SQUEEZER_CONTAINER.type();
    }

    public static class Serializer
    implements RecipeSerializer<SqueezerContainerRecipe> {
        public SqueezerContainerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack emptyContainer = RecipeSerializers.item(GsonHelper.m_13930_((JsonObject)json, (String)"container"));
            int processingTime = GsonHelper.m_13927_((JsonObject)json, (String)"time");
            ItemStack remnants = RecipeSerializers.item(GsonHelper.m_13930_((JsonObject)json, (String)"remnants"));
            float remnantsChance = GsonHelper.m_13915_((JsonObject)json, (String)"remnantsChance");
            return new SqueezerContainerRecipe(recipeId, emptyContainer, processingTime, remnants, remnantsChance);
        }

        public SqueezerContainerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStack emptyContainer = buffer.m_130267_();
            int processingTime = buffer.m_130242_();
            ItemStack remnants = buffer.m_130267_();
            float remnantsChance = buffer.readFloat();
            return new SqueezerContainerRecipe(recipeId, emptyContainer, processingTime, remnants, remnantsChance);
        }

        public void toNetwork(FriendlyByteBuf buffer, SqueezerContainerRecipe recipe) {
            buffer.m_130055_(recipe.emptyContainer);
            buffer.m_130130_(recipe.processingTime);
            buffer.m_130055_(recipe.remnants);
            buffer.writeFloat(recipe.remnantsChance);
        }
    }
}

