/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.centrifuge;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.ForestryConstants;
import forestry.api.core.Product;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.core.recipes.jei.ChanceTooltipCallback;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.recipes.jei.ForestryRecipeType;
import forestry.core.utils.JeiUtil;
import forestry.factory.blocks.BlockTypeFactoryTesr;
import forestry.factory.features.FactoryBlocks;
import forestry.modules.features.FeatureBlock;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CentrifugeRecipeCategory
extends ForestryRecipeCategory<ICentrifugeRecipe> {
    private static final ResourceLocation guiTexture = ForestryConstants.forestry("textures/gui/centrifugesocket2.png");
    private final IDrawableAnimated arrow;
    private final IDrawable icon;

    public CentrifugeRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(guiTexture, 11, 18, 154, 54), "block.forestry.centrifuge");
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(guiTexture, 176, 0, 4, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 80, IDrawableAnimated.StartDirection.BOTTOM, false);
        ItemStack centrifuge = new ItemStack(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.CENTRIFUGE)).block());
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)centrifuge);
    }

    public RecipeType<ICentrifugeRecipe> getRecipeType() {
        return ForestryRecipeType.CENTRIFUGE;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, ICentrifugeRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 19).addIngredients(recipe.getInput());
        List<IRecipeSlotBuilder> outputSlots = JeiUtil.layoutSlotGrid(builder, RecipeIngredientRole.OUTPUT, 3, 3, 101, 1, 18);
        List<Product> sortedProducts = recipe.getAllProducts().stream().sorted(Comparator.comparing(Product::chance).reversed()).toList();
        for (int i = 0; i < sortedProducts.size() && i < outputSlots.size(); ++i) {
            Product product = sortedProducts.get(i);
            ((IRecipeSlotBuilder)outputSlots.get(i).addItemStack(product.createStack())).addTooltipCallback((IRecipeSlotTooltipCallback)new ChanceTooltipCallback(product.chance()));
        }
    }

    public void draw(ICentrifugeRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 32, 18);
        this.arrow.draw(matrixStack, 56, 18);
    }
}

