/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.squeezer;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.ForestryConstants;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.core.recipes.jei.ChanceTooltipCallback;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.recipes.jei.ForestryRecipeType;
import forestry.core.utils.JeiUtil;
import forestry.factory.blocks.BlockTypeFactoryTesr;
import forestry.factory.features.FactoryBlocks;
import forestry.modules.features.FeatureBlock;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SqueezerRecipeCategory
extends ForestryRecipeCategory<ISqueezerRecipe> {
    private static final ResourceLocation guiTexture = ForestryConstants.forestry("textures/gui/squeezersocket.png");
    private final IDrawableAnimated arrow;
    private final IDrawable tankOverlay;
    private final IDrawable icon;
    private final ICraftingGridHelper craftingGridHelper;

    public SqueezerRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(guiTexture, 9, 16, 158, 62), "block.forestry.squeezer");
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(guiTexture, 176, 60, 43, 18);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tankOverlay = guiHelper.createDrawable(guiTexture, 176, 0, 16, 58);
        ItemStack squeezer = new ItemStack(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.SQUEEZER)).block());
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)squeezer);
        this.craftingGridHelper = guiHelper.createCraftingGridHelper();
    }

    public RecipeType<ISqueezerRecipe> getRecipeType() {
        return ForestryRecipeType.SQUEEZER;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, ISqueezerRecipe recipe, IFocusGroup focuses) {
        List<IRecipeSlotBuilder> craftingSlots = JeiUtil.layoutSlotGrid(builder, RecipeIngredientRole.INPUT, 3, 3, 8, 5, 18);
        JeiUtil.setCraftingItems(craftingSlots, recipe.getInputs(), 3, 3, this.craftingGridHelper);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 88, 44).addTooltipCallback((IRecipeSlotTooltipCallback)new ChanceTooltipCallback(recipe.getRemnantsChance())).addItemStack(recipe.getRemnants());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 113, 2).setFluidRenderer(10000L, false, 16, 58).setOverlay(this.tankOverlay, 0, 0).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getFluidOutput());
    }

    public void draw(ISqueezerRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        this.arrow.draw(stack, 67, 25);
    }
}

