/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.ForestryError;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.FluidRecipeFilter;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.InventoryGhostCrafting;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.RecipeUtils;
import forestry.factory.features.FactoryTiles;
import forestry.factory.gui.ContainerCarpenter;
import forestry.factory.inventory.InventoryCarpenter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileCarpenter
extends TilePowered
implements WorldlyContainer,
ILiquidTankTile,
IItemStackDisplay {
    private static final int TICKS_PER_RECIPE_TIME = 1;
    private static final int ENERGY_PER_WORK_CYCLE = 2040;
    private static final int ENERGY_PER_RECIPE_TIME = 204;
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final InventoryAdapterTile craftingInventory;
    private final ResultContainer craftPreviewInventory;
    @Nullable
    private ICarpenterRecipe currentRecipe;

    private ItemStack getBoxStack() {
        return this.getInternalInventory().m_8020_(9);
    }

    public TileCarpenter(BlockPos pos, BlockState state) {
        super(FactoryTiles.CARPENTER.tileType(), pos, state, 1100, 40000);
        this.setEnergyPerWorkCycle(2040);
        this.resourceTank = new FilteredTank(10000).setFilter(FluidRecipeFilter.CARPENTER_INPUT);
        this.craftingInventory = new InventoryGhostCrafting<TileCarpenter>(this, 10);
        this.craftPreviewInventory = new ResultContainer();
        this.setInternalInventory(new InventoryCarpenter(this));
        this.tankManager = new TankManager(this, this.resourceTank);
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        this.tankManager.write(compoundNBT);
        this.craftingInventory.write(compoundNBT);
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        this.tankManager.read(compoundNBT);
        this.craftingInventory.read(compoundNBT);
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(FriendlyByteBuf data) {
        super.readData(data);
        this.tankManager.readData(data);
    }

    public void checkRecipe() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.currentRecipe == null || !this.currentRecipe.matches(this.resourceTank.getFluid(), this.getBoxStack(), (Container)this.craftingInventory, this.f_58857_)) {
            ICarpenterRecipe recipe;
            this.currentRecipe = recipe = RecipeUtils.getCarpenterRecipe(this.f_58857_.m_7465_(), this.resourceTank.getFluid(), this.getBoxStack(), (Container)this.craftingInventory, this.f_58857_);
            if (recipe != null) {
                int recipeTime = this.currentRecipe.getPackagingTime();
                this.setTicksPerWorkCycle(recipeTime * 1);
                this.setEnergyPerWorkCycle(recipeTime * 204);
                ItemStack craftingResult = this.currentRecipe.m_8043_();
                this.craftPreviewInventory.m_6836_(0, craftingResult);
            } else {
                this.craftPreviewInventory.m_6836_(0, ItemStack.f_41583_);
            }
        }
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (Container)this, 11);
        }
    }

    @Override
    public boolean workCycle() {
        if (!this.removeLiquidResources(true)) {
            return false;
        }
        if (!this.removeItemResources(true)) {
            return false;
        }
        if (this.currentRecipe != null) {
            ItemStack pendingProduct = this.currentRecipe.m_8043_();
            InventoryUtil.tryAddStack((Container)this, pendingProduct, 10, 1, true);
        }
        return true;
    }

    private boolean removeLiquidResources(boolean doRemove) {
        if (this.currentRecipe == null) {
            return true;
        }
        FluidStack fluid = this.currentRecipe.getInputFluid();
        if (!fluid.isEmpty()) {
            FluidStack drained = this.resourceTank.drainInternal(fluid, IFluidHandler.FluidAction.SIMULATE);
            if (!fluid.isFluidStackIdentical(drained)) {
                return false;
            }
            if (doRemove) {
                this.resourceTank.drainInternal(fluid, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return true;
    }

    private boolean removeItemResources(boolean doRemove) {
        if (this.currentRecipe == null) {
            return true;
        }
        if (!this.currentRecipe.getBox().m_43947_()) {
            ItemStack box = this.m_8020_(9);
            if (box.m_41619_()) {
                return false;
            }
            if (doRemove) {
                this.m_7407_(9, 1);
            }
        }
        InventoryMapper inventory = new InventoryMapper((Container)this.getInternalInventory(), 12, 18);
        return InventoryUtil.consumeIngredients(inventory, (List<Ingredient>)this.currentRecipe.getCraftingGridRecipe().m_7527_(), null, true, false, doRemove);
    }

    @Override
    public boolean hasWork() {
        if (this.updateOnInterval(20)) {
            this.checkRecipe();
        }
        boolean hasRecipe = this.currentRecipe != null;
        boolean hasLiquidResources = true;
        boolean hasItemResources = true;
        boolean canAdd = true;
        if (hasRecipe) {
            hasLiquidResources = this.removeLiquidResources(false);
            hasItemResources = this.removeItemResources(false);
            ItemStack pendingProduct = this.currentRecipe.m_8043_();
            canAdd = InventoryUtil.tryAddStack((Container)this, pendingProduct, 10, 1, true, false);
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, ForestryError.NO_RECIPE);
        errorLogic.setCondition(!hasLiquidResources, ForestryError.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(!hasItemResources, ForestryError.NO_RESOURCE_INVENTORY);
        errorLogic.setCondition(!canAdd, ForestryError.NO_SPACE_INVENTORY);
        return hasRecipe && hasItemResources && hasLiquidResources && canAdd;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    public Container getCraftingInventory() {
        return this.craftingInventory;
    }

    public Container getCraftPreviewInventory() {
        return this.craftPreviewInventory;
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        this.craftPreviewInventory.m_6836_(0, itemStack);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return super.getCapability(capability, facing);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerCarpenter(windowId, player.m_150109_(), this);
    }
}

