/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.ForestryError;
import forestry.api.core.IErrorLogic;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.FluidTagFilter;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.IRenderableTile;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.RecipeUtils;
import forestry.factory.features.FactoryTiles;
import forestry.factory.gui.ContainerMoistener;
import forestry.factory.inventory.InventoryMoistener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileMoistener
extends TileBase
implements WorldlyContainer,
ILiquidTankTile,
IRenderableTile {
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    @Nullable
    private IMoistenerRecipe currentRecipe;
    private int burnTime = 0;
    private int totalTime = 0;
    private int productionTime = 0;
    private int timePerItem = 0;
    @Nullable
    private ItemStack currentProduct;
    @Nullable
    private ItemStack pendingProduct;

    public TileMoistener(BlockPos pos, BlockState state) {
        super(FactoryTiles.MOISTENER.tileType(), pos, state);
        this.setInternalInventory(new InventoryMoistener(this));
        this.resourceTank = new FilteredTank(10000).setFilter(FluidTagFilter.WATER);
        this.tankManager = new TankManager(this, this.resourceTank);
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        CompoundTag CompoundNBTP;
        super.m_183515_(compoundNBT);
        compoundNBT.m_128405_("BurnTime", this.burnTime);
        compoundNBT.m_128405_("TotalTime", this.totalTime);
        compoundNBT.m_128405_("ProductionTime", this.productionTime);
        this.tankManager.write(compoundNBT);
        if (this.pendingProduct != null) {
            CompoundNBTP = new CompoundTag();
            this.pendingProduct.m_41739_(CompoundNBTP);
            compoundNBT.m_128365_("PendingProduct", (Tag)CompoundNBTP);
        }
        if (this.currentProduct != null) {
            CompoundNBTP = new CompoundTag();
            this.currentProduct.m_41739_(CompoundNBTP);
            compoundNBT.m_128365_("CurrentProduct", (Tag)CompoundNBTP);
        }
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        CompoundTag compoundNBTP;
        super.m_142466_(compoundNBT);
        this.burnTime = compoundNBT.m_128451_("BurnTime");
        this.totalTime = compoundNBT.m_128451_("TotalTime");
        this.productionTime = compoundNBT.m_128451_("ProductionTime");
        this.tankManager.read(compoundNBT);
        if (compoundNBT.m_128441_("PendingProduct")) {
            compoundNBTP = compoundNBT.m_128469_("PendingProduct");
            this.pendingProduct = ItemStack.m_41712_((CompoundTag)compoundNBTP);
        }
        if (compoundNBT.m_128441_("CurrentProduct")) {
            compoundNBTP = compoundNBT.m_128469_("CurrentProduct");
            this.currentProduct = ItemStack.m_41712_((CompoundTag)compoundNBTP);
        }
        this.checkRecipe();
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(FriendlyByteBuf data) {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        boolean gloomy;
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (Container)this, 10);
        }
        int lightvalue = level.m_7146_(this.m_58899_().m_7494_());
        IErrorLogic errorLogic = this.getErrorLogic();
        if (errorLogic.setCondition(!(gloomy = lightvalue <= 11), ForestryError.NOT_DARK)) {
            return;
        }
        int speed = lightvalue >= 9 ? 1 : (lightvalue >= 7 ? 2 : (lightvalue >= 5 ? 3 : 4));
        if (this.burnTime > 0 && this.pendingProduct == null) {
            boolean hasLiquid = this.resourceTank.getFluidAmount() > 0;
            if (errorLogic.setCondition(!hasLiquid, ForestryError.NO_RESOURCE_LIQUID)) {
                return;
            }
            this.checkRecipe();
            if (this.currentRecipe == null) {
                return;
            }
            this.resourceTank.drain(1, IFluidHandler.FluidAction.EXECUTE);
            this.burnTime -= speed;
            this.productionTime -= speed;
            if (this.productionTime <= 0) {
                this.pendingProduct = this.currentProduct;
                this.m_7407_(11, 1);
                this.resetRecipe();
                this.tryAddPending();
            }
        } else if (this.pendingProduct != null) {
            this.tryAddPending();
        } else if (this.rotateWorkingSlot()) {
            this.checkRecipe();
            if (this.m_8020_(9).m_41619_()) {
                return;
            }
            if (FuelManager.moistenerResource.containsKey(this.m_8020_(9))) {
                MoistenerFuel res = FuelManager.moistenerResource.get(this.m_8020_(9));
                this.burnTime = this.totalTime = res.moistenerValue();
            }
        } else {
            this.rotateReservoir();
        }
        errorLogic.setCondition(this.currentRecipe == null, ForestryError.NO_RECIPE);
    }

    private boolean tryAddPending() {
        if (this.pendingProduct == null) {
            return false;
        }
        boolean added = InventoryUtil.tryAddStack((Container)this, this.pendingProduct, 10, 1, true);
        this.getErrorLogic().setCondition(!added, ForestryError.NO_SPACE_INVENTORY);
        if (added) {
            this.pendingProduct = null;
        }
        return added;
    }

    public void checkRecipe() {
        RecipeManager manager = RecipeUtils.getRecipeManager();
        IMoistenerRecipe sameRec = null;
        if (manager != null) {
            sameRec = RecipeUtils.getMoistenerRecipe(manager, this.getInternalInventory().m_8020_(11));
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
        this.getErrorLogic().setCondition(this.currentRecipe == null, ForestryError.NO_RECIPE);
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.currentProduct = null;
            this.productionTime = 0;
            this.timePerItem = 0;
        } else {
            this.currentProduct = this.currentRecipe.getProduct();
            this.productionTime = this.currentRecipe.getTimePerItem();
            this.timePerItem = this.currentRecipe.getTimePerItem();
        }
    }

    private int getFreeSlot(ItemStack deposit, int startSlot, int endSlot, boolean emptyOnly) {
        int slot = -1;
        for (int i = startSlot; i < endSlot; ++i) {
            ItemStack slotStack = this.m_8020_(i);
            if (slotStack.m_41619_()) {
                if (slot >= 0) continue;
                slot = i;
                continue;
            }
            if (emptyOnly || !slotStack.m_41656_(deposit) || slotStack.m_41613_() >= slotStack.m_41741_()) continue;
            slot = i;
        }
        return slot;
    }

    private int getFreeStashSlot(ItemStack deposit, boolean emptyOnly) {
        return this.getFreeSlot(deposit, 0, 6, emptyOnly);
    }

    private int getFreeReservoirSlot(ItemStack deposit) {
        return this.getFreeSlot(deposit, 6, 9, false);
    }

    private int getNextResourceSlot(int startSlot, int endSlot) {
        int stage = -1;
        int resourceSlot = -1;
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = startSlot; i < endSlot; ++i) {
            ItemStack slotStack = inventory.m_8020_(i);
            if (slotStack.m_41619_() || !FuelManager.moistenerResource.containsKey(slotStack)) continue;
            MoistenerFuel res = FuelManager.moistenerResource.get(slotStack);
            if (stage >= 0 && res.stage() >= stage) continue;
            stage = res.stage();
            resourceSlot = i;
        }
        return resourceSlot;
    }

    private boolean rotateWorkingSlot() {
        IErrorLogic errorLogic = this.getErrorLogic();
        if (!this.m_8020_(9).m_41619_()) {
            ItemStack deposit;
            if (FuelManager.moistenerResource.containsKey(this.m_8020_(9))) {
                MoistenerFuel res = FuelManager.moistenerResource.get(this.m_8020_(9));
                deposit = res.product().m_41777_();
            } else {
                deposit = this.m_8020_(9).m_41777_();
            }
            int targetSlot = this.getFreeReservoirSlot(deposit);
            if (errorLogic.setCondition(targetSlot < 0, ForestryError.NO_SPACE_INVENTORY)) {
                return false;
            }
            if (this.m_8020_(targetSlot).m_41619_()) {
                this.m_6836_(targetSlot, deposit);
            } else {
                this.m_8020_(targetSlot).m_41769_(1);
            }
            this.m_7407_(9, 1);
        }
        if (!this.m_8020_(9).m_41619_()) {
            return true;
        }
        int resourceSlot = this.getNextResourceSlot(6, 9);
        if (errorLogic.setCondition(resourceSlot < 0, ForestryError.NO_RESOURCE)) {
            return false;
        }
        this.m_6836_(9, this.m_7407_(resourceSlot, 1));
        return true;
    }

    private void rotateReservoir() {
        int targetSlot;
        int resourceSlot;
        ArrayList<Integer> slotsToShift = new ArrayList<Integer>();
        for (int i = 6; i < 9; ++i) {
            if (this.m_8020_(i).m_41619_() || FuelManager.moistenerResource.containsKey(this.m_8020_(i))) continue;
            slotsToShift.add(i);
        }
        int shiftedSlots = 0;
        Iterator iterator = slotsToShift.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack slotStack = this.m_8020_(slot);
            int targetSlot2 = this.getFreeStashSlot(slotStack, true);
            if (targetSlot2 < 0) continue;
            this.m_6836_(targetSlot2, slotStack);
            this.m_6836_(slot, ItemStack.f_41583_);
            ++shiftedSlots;
        }
        for (int i = 0; i < (!slotsToShift.isEmpty() ? shiftedSlots : 2) && (resourceSlot = this.getNextResourceSlot(0, 6)) >= 0 && (targetSlot = this.getFreeReservoirSlot(this.m_8020_(resourceSlot))) >= 0; ++i) {
            if (this.m_8020_(targetSlot).m_41619_()) {
                this.m_6836_(targetSlot, this.m_8020_(resourceSlot));
                this.m_6836_(resourceSlot, ItemStack.f_41583_);
                continue;
            }
            ItemStackUtil.mergeStacks(this.m_8020_(resourceSlot), this.m_8020_(targetSlot));
        }
    }

    public boolean isWorking() {
        return this.burnTime > 0 && this.resourceTank.getFluidAmount() > 0;
    }

    public boolean hasFuelMin(float percentage) {
        int max = 0;
        int avail = 0;
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = 0; i < 6; ++i) {
            MoistenerFuel res;
            if (inventory.m_8020_(i).m_41619_()) {
                max += 64;
                continue;
            }
            if (!FuelManager.moistenerResource.containsKey(inventory.m_8020_(i)) || !ItemStack.m_41746_((ItemStack)(res = FuelManager.moistenerResource.get(inventory.m_8020_(i))).resource(), (ItemStack)inventory.m_8020_(i))) continue;
            max += 64;
            avail += inventory.m_8020_(i).m_41613_();
        }
        return (float)avail / (float)max > percentage;
    }

    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.m_8020_(11).m_41619_()) {
            return false;
        }
        return (float)inventory.m_8020_(11).m_41613_() / (float)inventory.m_8020_(11).m_41741_() > percentage;
    }

    public boolean isProducing() {
        return this.productionTime > 0;
    }

    public int getProductionProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return 0;
        }
        return this.productionTime * i / this.timePerItem;
    }

    public int getConsumptionProgressScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return TankRenderInfo.EMPTY;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
                break;
            }
            case 2: {
                this.productionTime = j;
                break;
            }
            case 3: {
                this.timePerItem = j;
            }
        }
    }

    public void sendGUINetworkData(AbstractContainerMenu container, ContainerListener iCrafting) {
        iCrafting.m_142153_(container, 0, this.burnTime);
        iCrafting.m_142153_(container, 1, this.totalTime);
        iCrafting.m_142153_(container, 2, this.productionTime);
        iCrafting.m_142153_(container, 3, this.timePerItem);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerMoistener(windowId, inv, this);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return super.getCapability(capability, facing);
    }
}

