/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.ForestryError;
import forestry.api.core.IErrorLogic;
import forestry.core.fluids.ContainerFiller;
import forestry.core.fluids.DrainOnlyFluidHandlerWrapper;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.FluidTagFilter;
import forestry.core.fluids.TankManager;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TileBase;
import forestry.factory.features.FactoryTiles;
import forestry.factory.gui.ContainerRaintank;
import forestry.factory.inventory.InventoryRaintank;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileRaintank
extends TileBase
implements WorldlyContainer,
ILiquidTankTile {
    private static final FluidStack STACK_WATER = new FluidStack((Fluid)Fluids.f_76193_, 1000);
    private static final FluidStack WATER_PER_UPDATE = new FluidStack((Fluid)Fluids.f_76193_, 10);
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final ContainerFiller containerFiller;
    @Nullable
    private Boolean canDumpBelow = null;
    private boolean dumpingFluid = false;
    private int fillingProgress;

    public TileRaintank(BlockPos pos, BlockState state) {
        super(FactoryTiles.RAIN_TANK.tileType(), pos, state);
        this.setInternalInventory(new InventoryRaintank(this));
        this.resourceTank = new FilteredTank(30000).setFilter(FluidTagFilter.WATER);
        this.tankManager = new TankManager(this, this.resourceTank);
        this.containerFiller = new ContainerFiller(this.resourceTank, 12, (Container)this, 0, 1);
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        this.tankManager.write(compoundNBT);
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        this.tankManager.read(compoundNBT);
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(FriendlyByteBuf data) {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.updateOnInterval(20)) {
            IErrorLogic errorLogic = this.getErrorLogic();
            Biome biome = (Biome)level.m_204166_(pos).m_203334_();
            errorLogic.setCondition(biome.m_47530_() != Biome.Precipitation.RAIN, ForestryError.NO_RAIN_BIOME);
            BlockPos posAbove = pos.m_7494_();
            boolean hasSky = level.m_46861_(posAbove);
            errorLogic.setCondition(!hasSky, ForestryError.NO_SKY_RAIN_TANK);
            errorLogic.setCondition(!level.m_46758_(posAbove), ForestryError.NOT_RAINING);
            if (!errorLogic.hasErrors()) {
                this.resourceTank.fillInternal(WATER_PER_UPDATE, IFluidHandler.FluidAction.EXECUTE);
            }
            this.containerFiller.updateServerSide();
        }
        if (this.canDumpBelow == null) {
            this.canDumpBelow = FluidHelper.canAcceptFluid(level, this.m_58899_().m_7495_(), Direction.UP, STACK_WATER);
        }
        if (this.canDumpBelow.booleanValue() && (this.dumpingFluid || this.updateOnInterval(20))) {
            this.dumpingFluid = this.dumpFluidBelow();
        }
    }

    private boolean dumpFluidBelow() {
        LazyOptional fluidCap;
        if (!this.resourceTank.isEmpty() && (fluidCap = FluidUtil.getFluidHandler((Level)this.f_58857_, (BlockPos)this.f_58858_.m_7495_(), (Direction)Direction.UP)).isPresent()) {
            return !FluidUtil.tryFluidTransfer((IFluidHandler)((IFluidHandler)fluidCap.orElse(null)), (IFluidHandler)this.tankManager, (int)50, (boolean)true).isEmpty();
        }
        return false;
    }

    public boolean isFilling() {
        return this.fillingProgress > 0;
    }

    public int getFillProgressScaled(int i) {
        return this.fillingProgress * i / 12;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingProgress = j;
            }
        }
    }

    public void sendGUINetworkData(AbstractContainerMenu container, ContainerListener iCrafting) {
        iCrafting.m_142153_(container, 0, this.containerFiller.getFillingProgress());
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void onNeighborTileChange(Level world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborTileChange(world, pos, neighbor);
        if (neighbor.equals((Object)pos.m_7495_())) {
            this.canDumpBelow = FluidHelper.canAcceptFluid(world, neighbor, Direction.UP, STACK_WATER);
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> {
                if (facing == Direction.DOWN) {
                    return new DrainOnlyFluidHandlerWrapper(this.tankManager);
                }
                return this.tankManager;
            }).cast();
        }
        return super.getCapability(capability, facing);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerRaintank(windowId, inv, this);
    }
}

