/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.blocks;

import forestry.core.blocks.BlockStructure;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.blocks.EnumFarmMaterial;
import forestry.farming.tiles.TileFarmControl;
import forestry.farming.tiles.TileFarmGearbox;
import forestry.farming.tiles.TileFarmHatch;
import forestry.farming.tiles.TileFarmPlain;
import forestry.farming.tiles.TileFarmValve;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;

public class BlockFarm
extends BlockStructure
implements EntityBlock {
    private final EnumFarmBlockType type;
    private final EnumFarmMaterial farmMaterial;
    public static final EnumProperty<State> STATE = EnumProperty.m_61587_((String)"state", State.class);

    public static BlockFarm create(EnumFarmBlockType type, EnumFarmMaterial material) {
        if (type == EnumFarmBlockType.PLAIN) {
            return new Plain(material);
        }
        return new BlockFarm(type, material);
    }

    public BlockFarm(EnumFarmBlockType type, EnumFarmMaterial farmMaterial) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.0f));
        this.type = type;
        this.farmMaterial = farmMaterial;
    }

    public EnumFarmBlockType getType() {
        return this.type;
    }

    public EnumFarmMaterial getFarmMaterial() {
        return this.farmMaterial;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.type) {
            case EnumFarmBlockType.GEARBOX -> new TileFarmGearbox(pos, state);
            case EnumFarmBlockType.HATCH -> new TileFarmHatch(pos, state);
            case EnumFarmBlockType.VALVE -> new TileFarmValve(pos, state);
            case EnumFarmBlockType.CONTROL -> new TileFarmControl(pos, state);
            default -> new TileFarmPlain(pos, state);
        };
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return this.getType() == EnumFarmBlockType.CONTROL;
    }

    public static class Plain
    extends BlockFarm {
        public Plain(EnumFarmMaterial farmMaterial) {
            super(EnumFarmBlockType.PLAIN, farmMaterial);
            this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STATE, (Comparable)((Object)State.PLAIN)));
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{STATE});
        }
    }

    public static enum State implements StringRepresentable
    {
        PLAIN,
        BAND;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

