/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.ForestryConstants;
import forestry.api.circuits.ICircuit;
import forestry.api.farming.IFarmType;
import forestry.api.farming.IFarmable;
import forestry.api.farming.Soil;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.features.CoreItems;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.utils.JeiUtil;
import forestry.farming.compat.FarmingInfoRecipe;
import java.awt.Color;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableInt;

public class FarmingInfoRecipeCategory
extends ForestryRecipeCategory<FarmingInfoRecipe> {
    public static final RecipeType<FarmingInfoRecipe> TYPE = RecipeType.create((String)"forestry", (String)"farming", FarmingInfoRecipe.class);
    private final IDrawable slotDrawable;
    private final IDrawable addition;
    private final IDrawable arrow;
    private final IDrawable icon;

    public FarmingInfoRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createBlankDrawable(144, 90), "for.jei.farming");
        this.slotDrawable = guiHelper.getSlotDrawable();
        ResourceLocation resourceLocation = ForestryConstants.forestry("textures/gui/jei/recipes.png");
        this.addition = guiHelper.createDrawable(resourceLocation, 44, 0, 15, 15);
        this.arrow = guiHelper.createDrawable(resourceLocation, 59, 0, 15, 15);
        ItemStack intricateCircuitboard = new ItemStack((ItemLike)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.INTRICATE));
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)intricateCircuitboard);
    }

    public RecipeType<FarmingInfoRecipe> getRecipeType() {
        return TYPE;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, FarmingInfoRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 64, 19).setBackground(this.slotDrawable, -1, -1).addItemStack(recipe.tube());
        IFarmType properties = recipe.properties();
        List<IRecipeSlotBuilder> soilSlots = JeiUtil.layoutSlotGrid(builder, RecipeIngredientRole.INPUT, 2, 2, 1, 55, 18);
        List<IRecipeSlotBuilder> germlingSlots = JeiUtil.layoutSlotGrid(builder, RecipeIngredientRole.INPUT, 2, 2, 55, 55, 18);
        List<IRecipeSlotBuilder> productSlots = JeiUtil.layoutSlotGrid(builder, RecipeIngredientRole.OUTPUT, 2, 2, 109, 55, 18);
        int soilSlotsSize = soilSlots.size();
        int germlingSlotsSize = germlingSlots.size();
        int productSlotsSize = productSlots.size();
        soilSlots.forEach(slot -> slot.setBackground(this.slotDrawable, -1, -1));
        germlingSlots.forEach(slot -> slot.setBackground(this.slotDrawable, -1, -1));
        productSlots.forEach(slot -> slot.setBackground(this.slotDrawable, -1, -1));
        MutableInt germlingSlotIndex = new MutableInt();
        MutableInt productSlotIndex = new MutableInt();
        int soilSlotIndex = 0;
        for (IFarmable farmable : properties.getFarmables()) {
            farmable.addGermlings(germling -> ((IRecipeSlotBuilder)germlingSlots.get(germlingSlotIndex.getAndIncrement() % germlingSlotsSize)).addItemStack(germling));
            farmable.addProducts(product -> ((IRecipeSlotBuilder)productSlots.get(productSlotIndex.getAndIncrement() % productSlotsSize)).addItemStack(product));
        }
        for (Soil soil : properties.getSoils()) {
            soilSlots.get(soilSlotIndex++ % soilSlotsSize).addItemStack(soil.resource());
        }
    }

    public void draw(FarmingInfoRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        this.addition.draw(stack, 37, 64);
        this.arrow.draw(stack, 91, 64);
        int recipeWidth = this.getBackground().getWidth();
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        ICircuit circuit = recipe.circuit();
        float textX = (float)(recipeWidth - fontRenderer.m_92895_(circuit.getDisplayName().getString())) / 2.0f;
        fontRenderer.m_92889_(stack, circuit.getDisplayName(), textX, 3.0f, Color.darkGray.getRGB());
        MutableComponent soilName = Component.m_237115_((String)"for.jei.farming.soil");
        fontRenderer.m_92889_(stack, (Component)soilName, 18.0f - (float)fontRenderer.m_92895_(soilName.getString()) / 2.0f, 45.0f, Color.darkGray.getRGB());
        MutableComponent germlingsName = Component.m_237115_((String)"for.jei.farming.germlings");
        fontRenderer.m_92889_(stack, (Component)germlingsName, (float)(recipeWidth - fontRenderer.m_92895_(germlingsName.getString())) / 2.0f, 45.0f, Color.darkGray.getRGB());
        MutableComponent productsName = Component.m_237115_((String)"for.jei.farming.products");
        fontRenderer.m_92889_(stack, (Component)productsName, 126.0f - (float)fontRenderer.m_92895_(productsName.getString()) / 2.0f, 45.0f, Color.darkGray.getRGB());
    }
}

