/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmType;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.farming.multiblock.IFarmControllerInternal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class FarmLogicSlot
extends Widget {
    private final IFarmControllerInternal farmController;
    private final Direction farmDirection;
    protected final ToolTip toolTip = new ToolTip(250){

        @Override
        public void refresh() {
            FarmLogicSlot.this.toolTip.clear();
            FarmLogicSlot.this.toolTip.add(FarmLogicSlot.this.getProperties().getDisplayName(FarmLogicSlot.this.getLogic().isManual()));
            FarmLogicSlot.this.toolTip.add((Component)Component.m_237110_((String)"for.gui.farm.fertilizer", (Object[])new Object[]{FarmLogicSlot.this.getProperties().getFertilizerConsumption(FarmLogicSlot.this.farmController)}));
            FarmLogicSlot.this.toolTip.add((Component)Component.m_237110_((String)"for.gui.farm.water", (Object[])new Object[]{FarmLogicSlot.this.getProperties().getWaterConsumption(FarmLogicSlot.this.farmController, FarmLogicSlot.this.farmController.getFarmLedgerDelegate().getHydrationModifier())}));
        }
    };

    public FarmLogicSlot(IFarmControllerInternal farmController, WidgetManager manager, int xPos, int yPos, Direction farmDirection) {
        super(manager, xPos, yPos);
        this.farmController = farmController;
        this.farmDirection = farmDirection;
    }

    private IFarmLogic getLogic() {
        return this.farmController.getFarmLogic(this.farmDirection);
    }

    private IFarmType getProperties() {
        return this.getLogic().getType();
    }

    private ItemStack getStackIndex() {
        return this.getProperties().getIcon();
    }

    @Override
    public void draw(PoseStack transform, int startX, int startY) {
        if (!this.getStackIndex().m_41619_()) {
            Minecraft minecraft = Minecraft.m_91087_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            GuiUtil.drawItemStack(transform, minecraft.f_91062_, this.getStackIndex(), startX + this.xPos, startY + this.yPos);
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            return this.toolTip;
        }
        return null;
    }
}

