/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.widgets.SocketWidget;
import forestry.core.gui.widgets.TankWidget;
import forestry.farming.gui.ContainerFarm;
import forestry.farming.gui.FarmLedger;
import forestry.farming.gui.FarmLogicSlot;
import forestry.farming.multiblock.IFarmControllerInternal;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarm;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class GuiFarm
extends GuiForestryTitled<ContainerFarm> {
    private final TileFarm tile;

    public GuiFarm(ContainerFarm container, Inventory inv, Component title) {
        super("textures/gui/mfarm.png", container, inv, title);
        this.tile = (TileFarm)container.getTile();
        this.widgetManager.add(new TankWidget(this.widgetManager, 15, 19, 0).setOverlayOrigin(216, 18));
        this.widgetManager.add(new SocketWidget(this.widgetManager, 69, 40, this.tile, 0));
        IFarmControllerInternal farmController = ((MultiblockLogicFarm)this.tile.getMultiblockLogic()).getController();
        this.widgetManager.add(new FarmLogicSlot(farmController, this.widgetManager, 69, 22, Direction.NORTH));
        this.widgetManager.add(new FarmLogicSlot(farmController, this.widgetManager, 69, 58, Direction.SOUTH));
        this.widgetManager.add(new FarmLogicSlot(farmController, this.widgetManager, 51, 40, Direction.WEST));
        this.widgetManager.add(new FarmLogicSlot(farmController, this.widgetManager, 87, 40, Direction.EAST));
        this.f_97726_ = 216;
        this.f_97727_ = 220;
    }

    @Override
    protected void addLedgers() {
        IFarmControllerInternal farmController = ((MultiblockLogicFarm)this.tile.getMultiblockLogic()).getController();
        this.addErrorLedger(farmController);
        this.addClimateLedger(farmController);
        this.ledgerManager.add(new FarmLedger(this.ledgerManager, farmController.getFarmLedgerDelegate()));
        this.addHintLedger("farm");
    }

    @Override
    protected void m_7286_(PoseStack transform, float partialTicks, int mouseY, int mouseX) {
        super.m_7286_(transform, partialTicks, mouseY, mouseX);
        int fertilizerRemain = ((MultiblockLogicFarm)this.tile.getMultiblockLogic()).getController().getStoredFertilizerScaled(16);
        if (fertilizerRemain > 0) {
            this.m_93228_(transform, this.f_97735_ + 81, this.f_97736_ + 94 + 17 - fertilizerRemain, this.f_97726_, 17 - fertilizerRemain, 4, fertilizerRemain);
        }
    }
}

