/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmType;
import forestry.api.farming.IFarmable;
import forestry.farming.logic.FarmLogicHomogeneous;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class FarmLogicArboreal
extends FarmLogicHomogeneous {
    @Nullable
    private List<IFarmable> farmables;

    public FarmLogicArboreal(IFarmType properties, boolean isManual) {
        super(properties, isManual);
    }

    public List<IFarmable> getFarmables() {
        if (this.farmables == null) {
            this.farmables = new ArrayList<IFarmable>(this.type.getFarmables());
        }
        return this.farmables;
    }

    @Override
    public List<ItemStack> collect(Level level, IFarmHousing farmHousing) {
        return this.collectEntityItems(level, farmHousing, true);
    }

    @Override
    public Collection<ICrop> harvest(Level level, IFarmHousing farmHousing, Direction direction, int extent, BlockPos pos) {
        BlockPos position = farmHousing.getValidPosition(direction, pos, extent, pos.m_7494_());
        Collection<ICrop> crops = this.harvestBlocks(level, position);
        farmHousing.increaseExtent(direction, pos, extent);
        return crops;
    }

    private Collection<ICrop> harvestBlocks(Level world, BlockPos position) {
        IFarmable farmable = FarmLogicArboreal.getFarmableForBlock(world, position, this.getFarmables());
        if (farmable == null) {
            return Collections.emptyList();
        }
        Stack<BlockPos> knownCropPositions = new Stack<BlockPos>();
        knownCropPositions.add(position);
        HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
        Stack<ICrop> crops = new Stack<ICrop>();
        while (!knownCropPositions.empty()) {
            BlockPos knownCropPos = (BlockPos)knownCropPositions.pop();
            for (BlockPos mutable : BlockPos.m_121940_((BlockPos)knownCropPos.m_7918_(-1, -1, -1), (BlockPos)knownCropPos.m_7918_(1, 1, 1))) {
                if (!world.m_46805_(mutable)) {
                    return crops;
                }
                BlockPos candidate = mutable.m_7949_();
                if (checkedBlocks.contains(candidate)) continue;
                checkedBlocks.add(candidate);
                BlockState blockState = world.m_8055_(candidate);
                ICrop crop = farmable.getCropAt(world, candidate, blockState);
                if (crop == null) continue;
                crops.push(crop);
                knownCropPositions.push(candidate);
            }
        }
        return crops;
    }

    @Nullable
    private static IFarmable getFarmableForBlock(Level world, BlockPos position, Collection<IFarmable> farmables) {
        if (world.m_46859_(position)) {
            return null;
        }
        BlockState blockState = world.m_8055_(position);
        for (IFarmable farmable : farmables) {
            ICrop crop = farmable.getCropAt(world, position, blockState);
            if (crop == null) continue;
            return farmable;
        }
        return null;
    }

    @Override
    protected boolean maintainSeedlings(Level world, IFarmHousing farmHousing, BlockPos pos, Direction direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            BlockPos soilPosition;
            BlockState soilState;
            BlockPos position = this.translateWithOffset(pos, direction, i);
            if (!world.m_46859_(position) || !this.isAcceptedSoil(soilState = world.m_8055_(soilPosition = position.m_7495_()))) continue;
            return this.plantSapling(world, farmHousing, position, direction);
        }
        return false;
    }

    private boolean plantSapling(Level world, IFarmHousing farmHousing, BlockPos position, Direction direction) {
        Collections.shuffle(this.getFarmables());
        for (IFarmable candidate : this.getFarmables()) {
            if (!farmHousing.plantGermling(candidate, world, position, direction)) continue;
            return true;
        }
        return false;
    }
}

