/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import com.google.common.collect.ImmutableSet;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmType;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicHomogeneous;
import forestry.farming.logic.crops.CropDestroy;
import forestry.farming.logic.farmables.FarmableChorus;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FarmLogicEnder
extends FarmLogicHomogeneous {
    private static final Set<Direction> VALID_DIRECTIONS = ImmutableSet.of((Object)Direction.UP, (Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.WEST, (Object)Direction.EAST);
    private final IFarmable chorusFarmable = FarmableChorus.INSTANCE;

    public FarmLogicEnder(IFarmType properties, boolean isManual) {
        super(properties, isManual);
    }

    @Override
    public List<ItemStack> collect(Level level, IFarmHousing farmHousing) {
        return this.collectEntityItems(level, farmHousing, true);
    }

    @Override
    public Collection<ICrop> harvest(Level level, IFarmHousing farmHousing, Direction direction, int extent, BlockPos pos) {
        BlockPos position = farmHousing.getValidPosition(direction, pos, extent, pos.m_7494_());
        Collection<ICrop> crops = this.harvestBlocks(level, position);
        farmHousing.increaseExtent(direction, pos, extent);
        return crops;
    }

    private Collection<ICrop> harvestBlocks(Level world, BlockPos position) {
        if (!world.m_46805_(position) || world.m_46859_(position)) {
            return Collections.emptySet();
        }
        ICrop crop = this.getCrop(world, position);
        if (crop != null) {
            return Collections.singleton(crop);
        }
        Stack<ICrop> crops = new Stack<ICrop>();
        Stack<ICrop> plants = new Stack<ICrop>();
        this.harvestBlock(world, position, Direction.DOWN, plants, crops);
        if (!crops.isEmpty()) {
            return crops;
        }
        return plants;
    }

    private boolean harvestBlock(Level world, BlockPos pos, Direction from, Stack<ICrop> plants, Stack<ICrop> flowers) {
        BlockState blockState = world.m_8055_(pos);
        if (blockState.m_60734_() == Blocks.f_50491_) {
            ICrop crop = this.chorusFarmable.getCropAt(world, pos, blockState);
            if (crop != null) {
                flowers.push(crop);
                return false;
            }
            return false;
        }
        if (blockState.m_60734_() == Blocks.f_50490_) {
            boolean canHarvest = true;
            for (Direction facing : VALID_DIRECTIONS) {
                if (facing == from) continue;
                canHarvest &= this.harvestBlock(world, pos.m_121945_(facing), facing.m_122424_(), plants, flowers);
            }
            if (canHarvest) {
                plants.push(new CropDestroy(world, Blocks.f_50490_.m_49966_(), pos, null));
            }
            return canHarvest;
        }
        return true;
    }

    @Override
    protected boolean maintainSeedlings(Level world, IFarmHousing farmHousing, BlockPos pos, Direction direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            BlockPos soilPos;
            BlockState blockState;
            BlockPos position = this.translateWithOffset(pos, direction, i);
            BlockState state = world.m_8055_(position);
            if (!world.m_46859_(position) && !BlockUtil.isReplaceableBlock(state, world, position) || !this.isAcceptedSoil(blockState = world.m_8055_(soilPos = position.m_7495_())) || !this.trySetCrop(world, farmHousing, position, direction)) continue;
            return true;
        }
        return false;
    }
}

