/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmType;
import forestry.api.farming.IFarmable;
import forestry.api.farming.Soil;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicSoil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public abstract class FarmLogicHomogeneous
extends FarmLogicSoil {
    public FarmLogicHomogeneous(IFarmType properties, boolean isManual) {
        super(properties, isManual);
    }

    protected boolean trySetCrop(Level world, IFarmHousing farmHousing, BlockPos position, Direction direction) {
        for (IFarmable candidate : this.getFarmables()) {
            if (!farmHousing.plantGermling(candidate, world, position, direction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean cultivate(Level level, IFarmHousing farmHousing, BlockPos pos, Direction direction, int extent) {
        return this.maintainSoil(level, farmHousing, pos, direction, extent) || this.maintainSeedlings(level, farmHousing, pos.m_7494_(), direction, extent);
    }

    private boolean maintainSoil(Level world, IFarmHousing farmHousing, BlockPos pos, Direction direction, int extent) {
        if (!farmHousing.canPlantSoil(this.isManual)) {
            return false;
        }
        block0: for (Soil soil : this.getSoils()) {
            NonNullList resources = NonNullList.m_122779_();
            resources.add((Object)soil.resource());
            if (!farmHousing.getFarmInventory().hasResources((List<ItemStack>)resources)) continue;
            for (int i = 0; i < extent; ++i) {
                BlockPos position = this.translateWithOffset(pos, direction, i);
                BlockState soilState = world.m_8055_(position);
                if (!world.m_46805_(position) || farmHousing.isValidPlatform(world, pos)) continue block0;
                if (!BlockUtil.isBreakableBlock(soilState, world, pos) || this.isAcceptedSoil(soilState)) continue;
                BlockPos platformPosition = position.m_7495_();
                if (!farmHousing.isValidPlatform(world, platformPosition)) continue block0;
                BlockUtil.getBlockDrops((LevelAccessor)world, position).forEach(farmHousing::addPendingProduct);
                BlockUtil.setBlockWithPlaceSound(world, position, soil.soilState());
                farmHousing.getFarmInventory().removeResources((List<ItemStack>)resources);
                return true;
            }
        }
        return false;
    }

    protected abstract boolean maintainSeedlings(Level var1, IFarmHousing var2, BlockPos var3, Direction var4, int var5);
}

