/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.crops;

import forestry.core.utils.BlockUtil;
import forestry.farming.logic.crops.Crop;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CropDestroyDouble
extends Crop {
    protected final BlockState blockState;
    protected final BlockState blockStateUp;
    @Nullable
    protected final BlockState replantState;

    public CropDestroyDouble(Level world, BlockState blockState, BlockState blockStateUp, BlockPos position, @Nullable BlockState replantState) {
        super(world, position);
        this.blockState = blockState;
        this.blockStateUp = blockStateUp;
        this.replantState = replantState;
    }

    @Override
    protected boolean isCrop(Level world, BlockPos pos) {
        return world.m_8055_(pos) == this.blockState;
    }

    @Override
    protected List<ItemStack> harvestBlock(Level level, BlockPos pos) {
        Block block = this.blockState.m_60734_();
        Block blockUp = this.blockStateUp.m_60734_();
        NonNullList harvested = NonNullList.m_122779_();
        BlockUtil.sendDestroyEffects(level, pos, this.blockState);
        level.m_7471_(pos.m_7494_(), false);
        if (this.replantState != null) {
            level.m_7731_(pos, this.replantState, 2);
        } else {
            level.m_7471_(pos, false);
        }
        return harvested;
    }

    public String toString() {
        return String.format("CropDestroyDouble [ position: [ %s ]; block: %s ]", this.position.toString(), this.blockState);
    }
}

