/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.crops.CropDestroy;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class FarmableBase
implements IFarmable {
    protected final ItemStack germling;
    protected final BlockState plantedState;
    protected final BlockState matureState;
    protected final boolean replant;

    public FarmableBase(ItemStack germling, BlockState plantedState, BlockState matureState, boolean replant) {
        this.germling = germling;
        this.plantedState = plantedState;
        this.matureState = matureState;
        this.replant = replant;
    }

    @Override
    public boolean isSaplingAt(Level level, BlockPos pos, BlockState state) {
        return state.m_60734_() == this.plantedState.m_60734_() && state != this.matureState;
    }

    @Override
    public ICrop getCropAt(Level level, BlockPos pos, BlockState state) {
        if (state != this.matureState) {
            return null;
        }
        BlockState replantState = this.replant ? this.plantedState : null;
        return new CropDestroy(level, state, pos, replantState);
    }

    @Override
    public boolean isGermling(ItemStack stack) {
        return ItemStack.m_41746_((ItemStack)this.germling, (ItemStack)stack);
    }

    @Override
    public void addGermlings(Consumer<ItemStack> accumulator) {
        accumulator.accept(this.germling);
    }

    @Override
    public boolean plantSaplingAt(Player player, ItemStack germling, Level level, BlockPos pos) {
        return BlockUtil.setBlockWithPlaceSound(level, pos, this.plantedState);
    }

    @Override
    public boolean isWindfall(ItemStack stack) {
        return false;
    }
}

