/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import com.google.common.base.Preconditions;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.farming.logic.crops.CropDestroy;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class FarmableRusticGrape
implements IFarmable {
    public static final BooleanProperty GRAPES = BooleanProperty.m_61465_((String)"grapes");
    private final Block cropBlock;

    public FarmableRusticGrape(Block cropBlock) {
        Preconditions.checkNotNull((Object)cropBlock);
        this.cropBlock = cropBlock;
    }

    @Override
    public boolean isSaplingAt(Level level, BlockPos pos, BlockState state) {
        return state.m_60734_() == this.cropBlock;
    }

    @Override
    @Nullable
    public ICrop getCropAt(Level level, BlockPos pos, BlockState state) {
        if (state.m_60734_() != this.cropBlock) {
            return null;
        }
        if (!((Boolean)state.m_61143_((Property)GRAPES)).booleanValue()) {
            return null;
        }
        BlockState replantState = this.getReplantState(state);
        return new CropDestroy(level, state, pos, replantState);
    }

    @Nullable
    protected BlockState getReplantState(BlockState blockState) {
        return (BlockState)blockState.m_61124_((Property)GRAPES, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean isGermling(ItemStack stack) {
        return false;
    }

    @Override
    public boolean plantSaplingAt(Player player, ItemStack germling, Level level, BlockPos pos) {
        return false;
    }

    @Override
    public boolean isWindfall(ItemStack stack) {
        return false;
    }
}

