/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.multiblock;

import forestry.api.IForestryApi;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmable;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.InventoryAdapterRestricted;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.SlotUtil;
import forestry.farming.multiblock.IFarmInventoryInternal;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public abstract class InventoryPlantation<H extends ILiquidTankTile & IFarmHousing>
extends InventoryAdapterRestricted
implements IFarmInventoryInternal {
    private static final int FERTILIZER_MODIFIER = 4;
    protected final H housing;
    protected final InventoryConfig config;
    protected final Container resourcesInventory;
    protected final Container germlingsInventory;
    protected final Container productInventory;
    protected final Container fertilizerInventory;

    public InventoryPlantation(H housing, InventoryConfig config) {
        super(config.count, "Items");
        this.housing = housing;
        this.config = config;
        this.resourcesInventory = new InventoryMapper((Container)this, config.resourcesStart, config.resourcesCount);
        this.germlingsInventory = new InventoryMapper((Container)this, config.germlingsStart, config.germlingsCount);
        this.productInventory = new InventoryMapper((Container)this, config.productionStart, config.productionCount);
        this.fertilizerInventory = new InventoryMapper((Container)this, config.fertilizerStart, config.fertilizerCount);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        if (SlotUtil.isSlotInRange(slotIndex, this.config.fertilizerStart, this.config.fertilizerCount)) {
            return this.acceptsAsFertilizer(stack);
        }
        if (SlotUtil.isSlotInRange(slotIndex, this.config.germlingsStart, this.config.germlingsCount)) {
            return this.acceptsAsSeedling(stack);
        }
        if (SlotUtil.isSlotInRange(slotIndex, this.config.resourcesStart, this.config.productionCount)) {
            return this.acceptsAsResource(stack);
        }
        if (SlotUtil.isSlotInRange(slotIndex, this.config.canStart, this.config.canCount)) {
            Optional fluid = FluidUtil.getFluidContained((ItemStack)stack);
            return fluid.map(f -> this.housing.getTankManager().canFillFluidType((FluidStack)f)).orElse(false);
        }
        return false;
    }

    @Override
    public boolean m_7157_(int slotIndex, ItemStack stack, Direction side) {
        return SlotUtil.isSlotInRange(slotIndex, this.config.productionStart, this.config.productionCount);
    }

    @Override
    public boolean hasResources(List<ItemStack> resources) {
        return InventoryUtil.contains(this.resourcesInventory, resources);
    }

    @Override
    public void removeResources(List<ItemStack> resources) {
        InventoryUtil.removeSets(this.resourcesInventory, 1, resources, null, false, false, true);
    }

    @Override
    public boolean acceptsAsSeedling(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (IFarmLogic logic : ((IFarmHousing)this.housing).getFarmLogics()) {
            if (!logic.getType().isAcceptedSeedling(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsAsResource(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (IFarmLogic logic : ((IFarmHousing)this.housing).getFarmLogics()) {
            if (!logic.getType().isAcceptedResource(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsAsFertilizer(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return IForestryApi.INSTANCE.getFarmingManager().getFertilizeValue(stack) > 0;
    }

    @Override
    public Container getProductInventory() {
        return this.productInventory;
    }

    @Override
    public Container getGermlingsInventory() {
        return this.germlingsInventory;
    }

    @Override
    public Container getResourcesInventory() {
        return this.resourcesInventory;
    }

    @Override
    public Container getFertilizerInventory() {
        return this.fertilizerInventory;
    }

    public void drainCan(TankManager tankManager) {
        FluidHelper.drainContainers(tankManager, (Container)this, this.config.canStart);
    }

    public abstract boolean plantGermling(IFarmable var1, Player var2, BlockPos var3);

    @Override
    public void stowProducts(Iterable<ItemStack> harvested, Stack<ItemStack> pendingProduce) {
        for (ItemStack harvest : harvested) {
            int added = InventoryUtil.addStack(this.productInventory, harvest, true);
            harvest.m_41774_(added);
            if (harvest.m_41619_()) continue;
            pendingProduce.push(harvest);
        }
    }

    @Override
    public boolean tryAddPendingProduce(Stack<ItemStack> pendingProduce) {
        ItemStack next;
        Container productInventory = this.getProductInventory();
        boolean added = InventoryUtil.tryAddStack(productInventory, next = pendingProduce.peek(), true, true);
        if (added) {
            pendingProduce.pop();
        }
        return added;
    }

    @Override
    public int getFertilizerValue() {
        ItemStack fertilizerStack = this.m_8020_(this.config.fertilizerStart);
        if (fertilizerStack.m_41619_()) {
            return 0;
        }
        int fertilizerValue = IForestryApi.INSTANCE.getFarmingManager().getFertilizeValue(fertilizerStack);
        if (fertilizerValue > 0) {
            return fertilizerValue * 4;
        }
        return 0;
    }

    @Override
    public boolean useFertilizer() {
        ItemStack fertilizer = this.m_8020_(this.config.fertilizerStart);
        if (this.acceptsAsFertilizer(fertilizer)) {
            this.m_7407_(this.config.fertilizerStart, 1);
            return true;
        }
        return false;
    }

    public static class InventoryConfig {
        public final int resourcesStart;
        public final int resourcesCount;
        public final int germlingsStart;
        public final int germlingsCount;
        public final int productionStart;
        public final int productionCount;
        public final int fertilizerStart;
        public final int fertilizerCount;
        public final int canStart;
        public final int canCount;
        public final int count;

        public InventoryConfig(int resourcesStart, int resourcesCount, int germlingsStart, int germlingsCount, int productionStart, int productionCount, int fertilizerStart, int fertilizerCount, int canStart, int canCount) {
            this.resourcesStart = resourcesStart;
            this.resourcesCount = resourcesCount;
            this.germlingsStart = germlingsStart;
            this.germlingsCount = germlingsCount;
            this.productionStart = productionStart;
            this.productionCount = productionCount;
            this.fertilizerStart = fertilizerStart;
            this.fertilizerCount = fertilizerCount;
            this.canStart = canStart;
            this.canCount = canCount;
            this.count = resourcesCount + germlingsCount + productionCount + fertilizerCount + canCount;
        }
    }
}

