/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.tiles;

import forestry.api.multiblock.IFarmComponent;
import forestry.core.inventory.AdjacentInventoryCache;
import forestry.core.tiles.AdjacentTileCache;
import forestry.core.utils.InventoryUtil;
import forestry.farming.features.FarmingTiles;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarm;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileFarmHatch
extends TileFarm
implements WorldlyContainer,
IFarmComponent.Active {
    private static final Direction[] dumpDirections = new Direction[]{Direction.DOWN};
    private final AdjacentTileCache tileCache = new AdjacentTileCache(this);
    private final AdjacentInventoryCache inventoryCache = new AdjacentInventoryCache(this, this.tileCache, tile -> !(tile instanceof TileFarm) && tile.m_58899_().m_123342_() < this.m_58899_().m_123342_());

    public TileFarmHatch(BlockPos pos, BlockState state) {
        super(FarmingTiles.HATCH.tileType(), pos, state);
    }

    @Override
    public boolean allowsAutomation() {
        return true;
    }

    @Override
    public void updateServer(int tickCount) {
        if (tickCount % 40 == 0) {
            Container productInventory = ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().getFarmInventory().getProductInventory();
            InvWrapper productItemHandler = new InvWrapper(productInventory);
            InventoryUtil.moveItemStack((IItemHandler)productItemHandler, this.inventoryCache.getAdjacentInventories());
        }
    }

    @Override
    public void updateClient(int tickCount) {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            SidedInvWrapper sidedInvWrapper = new SidedInvWrapper((WorldlyContainer)this, facing);
            return LazyOptional.of(() -> sidedInvWrapper).cast();
        }
        return super.getCapability(capability, facing);
    }
}

