/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.blocks;

import forestry.api.genetics.ILifeStage;
import forestry.api.lepidopterology.genetics.ButterflyLifeStage;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.SpeciesUtil;
import forestry.lepidopterology.blocks.MaterialCocoon;
import forestry.lepidopterology.tiles.TileCocoon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockCocoon
extends Block
implements EntityBlock {
    public static final VoxelShape BOUNDING_BOX = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)2);

    public BlockCocoon() {
        super(BlockBehaviour.Properties.m_60939_((Material)MaterialCocoon.INSTANCE).m_60977_().m_60918_(SoundType.f_56739_));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        TileCocoon tileCocoon = TileUtil.getTile((BlockGetter)world, pos, TileCocoon.class);
        if (tileCocoon == null || tileCocoon.m_58901_()) {
            return;
        }
        tileCocoon.onBlockTick();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileCocoon(pos, state, false);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing != Direction.UP || !facingState.m_60795_()) {
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        TileCocoon tile = TileUtil.getTile(world, pos, TileCocoon.class);
        if (tile == null) {
            return ItemStack.f_41583_;
        }
        IButterfly caterpillar = tile.getCaterpillar();
        int age = (Integer)state.m_61143_((Property)AGE);
        ItemStack stack = ((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).createStack(caterpillar, (ILifeStage)ButterflyLifeStage.COCOON);
        if (!stack.m_41619_() && stack.m_41783_() != null) {
            stack.m_41783_().m_128405_("Age", age);
        }
        return stack;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BOUNDING_BOX;
    }
}

