/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.EntityButterfly;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class AIButterflyBase
extends Goal {
    protected final EntityButterfly entity;

    protected AIButterflyBase(EntityButterfly entity) {
        this.entity = entity;
    }

    @Nullable
    protected Vec3 getRandomDestination() {
        if (this.entity.m_20069_()) {
            return this.getRandomDestinationUpwards();
        }
        Vec3 entityPos = this.entity.m_20182_();
        Vec3 randomTarget = DefaultRandomPos.m_148407_((PathfinderMob)this.entity, (int)16, (int)7, (Vec3)entityPos.m_82549_(new Vec3(0.0, -1.0, 1.0).m_82524_(this.entity.m_146908_())));
        if (randomTarget != null && this.validateDestination(randomTarget, false)) {
            return randomTarget;
        }
        return null;
    }

    @Nullable
    protected Vec3 getRandomDestinationUpwards() {
        Vec3 entityPos = this.entity.m_20182_();
        Vec3 destination = entityPos.m_82520_(0.0, (double)(this.entity.m_217043_().m_188503_(10) + 2), 0.0);
        if (this.validateDestination(destination, true)) {
            return destination;
        }
        return null;
    }

    private boolean validateDestination(Vec3 dest, boolean allowFluids) {
        if (dest.f_82480_ < 1.0) {
            return false;
        }
        BlockPos pos = new BlockPos(dest);
        if (!this.entity.f_19853_.m_46805_(pos)) {
            return false;
        }
        BlockState blockState = this.entity.f_19853_.m_8055_(pos);
        if (!allowFluids && blockState.m_60767_().m_76332_()) {
            return false;
        }
        if (!blockState.m_60795_()) {
            return false;
        }
        return this.entity.getButterfly().isAcceptedEnvironment(this.entity.f_19853_, dest.f_82479_, dest.f_82480_, dest.f_82481_);
    }
}

