/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.AIButterflyBase;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.entities.EnumButterflyState;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;

public class AIButterflyRest
extends AIButterflyBase {
    public AIButterflyRest(EntityButterfly entity) {
        super(entity);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        int z;
        if (this.entity.getExhaustion() < 1000 && this.entity.canFly()) {
            return false;
        }
        Vec3 entityPos = this.entity.m_20182_();
        int x = (int)entityPos.f_82479_;
        int y = (int)Math.floor(entityPos.f_82480_);
        BlockPos pos = new BlockPos(x, y, z = (int)entityPos.f_82481_);
        if (!this.canLand(pos)) {
            return false;
        }
        if (this.entity.f_19853_.m_46859_(pos = pos.m_121945_(Direction.DOWN))) {
            return false;
        }
        BlockState blockState = this.entity.f_19853_.m_8055_(pos);
        if (blockState.m_60767_().m_76332_()) {
            return false;
        }
        if (!this.entity.getButterfly().isAcceptedEnvironment(this.entity.f_19853_, x, pos.m_123342_(), z)) {
            return false;
        }
        this.entity.setDestination(null);
        this.entity.setState(EnumButterflyState.RESTING);
        return true;
    }

    public boolean m_8045_() {
        if (this.entity.getExhaustion() <= 0 && this.entity.canFly()) {
            return false;
        }
        return !this.entity.m_20069_();
    }

    public void m_8056_() {
    }

    public void m_8041_() {
    }

    public void m_8037_() {
        this.entity.changeExhaustion(-1);
    }

    private boolean canLand(BlockPos pos) {
        if (!this.entity.f_19853_.m_46805_(pos)) {
            return false;
        }
        BlockState blockState = this.entity.f_19853_.m_8055_(pos);
        if (!blockState.m_60795_()) {
            return false;
        }
        if (AIButterflyRest.isPlant(blockState)) {
            return true;
        }
        BlockState belowState = this.entity.f_19853_.m_8055_(pos.m_7495_());
        return AIButterflyRest.isRest(belowState) || belowState.m_204336_(BlockTags.f_13035_);
    }

    private static boolean isRest(BlockState state) {
        return state.m_204336_(BlockTags.f_13039_) || state.m_204336_(BlockTags.f_13032_);
    }

    private static boolean isPlant(BlockState state) {
        Block block = state.m_60734_();
        if (state.m_204336_(BlockTags.f_13041_)) {
            return true;
        }
        if (block instanceof IPlantable) {
            return true;
        }
        if (block instanceof BonemealableBlock) {
            return true;
        }
        return state.m_60767_() == Material.f_76300_;
    }
}

