/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.core.IProduct;
import forestry.api.genetics.ClimateHelper;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.api.genetics.alleles.ButterflyChromosomes;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IIntegerAllele;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.lepidopterology.genetics.ButterflyLifeStage;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.core.gui.GuiAlyzer;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public enum ButterflyAlyzerPlugin implements IAlyzerPlugin
{
    INSTANCE;

    private final IdentityHashMap<ISpecies<?>, ItemStack> iconStacks = GeneticsUtil.getIconStacks(ButterflyLifeStage.BUTTERFLY, (ISpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get());

    @Override
    public void drawAnalyticsPage1(PoseStack transform, Screen gui, ItemStack stack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            IIndividualHandlerItem.ifPresent(stack, (butterfly, stage) -> {
                IGenome genome = butterfly.getGenome();
                TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
                textLayout.startPage(transform, 12, 90, 155);
                textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.active"), 90);
                textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.inactive"), 155);
                textLayout.newLine();
                textLayout.newLine();
                guiAlyzer.drawSpeciesRow(transform, (Component)Component.m_237115_((String)"for.gui.species"), (IIndividual)butterfly, ButterflyChromosomes.SPECIES);
                textLayout.newLine();
                guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.size"), (IIndividual)butterfly, ButterflyChromosomes.SIZE);
                textLayout.newLine();
                guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.speed"), (IIndividual)butterfly, ButterflyChromosomes.SPEED);
                textLayout.newLine();
                guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.metabolism"), (IIndividual)butterfly, ButterflyChromosomes.METABOLISM);
                textLayout.newLine();
                textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.fertility"), 12);
                AllelePair<IIntegerAllele> fertilityPair = genome.getAllelePair(ButterflyChromosomes.FERTILITY);
                guiAlyzer.drawFertilityInfo(transform, fertilityPair.active().value(), 90, GuiAlyzer.getColorCoding(fertilityPair.active().dominant()), 8);
                guiAlyzer.drawFertilityInfo(transform, fertilityPair.inactive().value(), 155, GuiAlyzer.getColorCoding(fertilityPair.inactive().dominant()), 8);
                textLayout.newLine();
                guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.flowers"), (IIndividual)butterfly, (IChromosome<?>)ButterflyChromosomes.FLOWER_TYPE);
                textLayout.newLine();
                guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.effect"), (IIndividual)butterfly, (IChromosome<?>)ButterflyChromosomes.EFFECT);
                textLayout.newLine();
                textLayout.endPage(transform);
            });
        }
    }

    @Override
    public void drawAnalyticsPage2(PoseStack transform, Screen gui, ItemStack stack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            IIndividualHandlerItem.ifPresent(stack, (individual, stage) -> {
                MutableComponent nocturnal1;
                MutableComponent diurnal1;
                MutableComponent nocturnal0;
                MutableComponent diurnal0;
                IGenome genome = individual.getGenome();
                IButterflySpecies primaryAllele = genome.getActiveValue(ButterflyChromosomes.SPECIES);
                IButterflySpecies secondaryAllele = genome.getActiveValue(ButterflyChromosomes.SPECIES);
                TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
                textLayout.startPage(transform, 12, 90, 155);
                textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.active"), 90);
                textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.inactive"), 155);
                textLayout.newLine();
                textLayout.newLine();
                guiAlyzer.drawRow(transform, (Component)Component.m_237115_((String)"for.gui.climate"), (Component)ClimateHelper.toDisplay(primaryAllele.getTemperature()), (Component)ClimateHelper.toDisplay(secondaryAllele.getTemperature()), (IIndividual)individual, (IChromosome<?>)ButterflyChromosomes.SPECIES);
                textLayout.newLine();
                MutableComponent indentedTolerance = Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"for.gui.tolerance"));
                IValueAllele tempToleranceActive = (IValueAllele)((Object)genome.getActiveAllele(ButterflyChromosomes.TEMPERATURE_TOLERANCE));
                IValueAllele tempToleranceInactive = (IValueAllele)((Object)genome.getInactiveAllele(ButterflyChromosomes.TEMPERATURE_TOLERANCE));
                textLayout.drawLine(transform, (Component)indentedTolerance, 12);
                guiAlyzer.drawToleranceInfo(transform, BeeChromosomes.TEMPERATURE_TOLERANCE, tempToleranceActive, 90);
                guiAlyzer.drawToleranceInfo(transform, BeeChromosomes.TEMPERATURE_TOLERANCE, tempToleranceInactive, 155);
                textLayout.newLine();
                guiAlyzer.drawRow(transform, (Component)Component.m_237115_((String)"for.gui.humidity"), (Component)ClimateHelper.toDisplay(primaryAllele.getHumidity()), (Component)ClimateHelper.toDisplay(secondaryAllele.getHumidity()), (IIndividual)individual, (IChromosome<?>)ButterflyChromosomes.SPECIES);
                textLayout.newLine();
                IValueAllele humidToleranceActive = (IValueAllele)((Object)genome.getActiveAllele(ButterflyChromosomes.HUMIDITY_TOLERANCE));
                IValueAllele humidToleranceInactive = (IValueAllele)((Object)genome.getInactiveAllele(ButterflyChromosomes.HUMIDITY_TOLERANCE));
                textLayout.drawLine(transform, (Component)indentedTolerance, 12);
                guiAlyzer.drawToleranceInfo(transform, BeeChromosomes.TEMPERATURE_TOLERANCE, humidToleranceActive, 90);
                guiAlyzer.drawToleranceInfo(transform, BeeChromosomes.TEMPERATURE_TOLERANCE, humidToleranceInactive, 155);
                textLayout.newLine();
                textLayout.newLine();
                MutableComponent yes = Component.m_237115_((String)"for.yes");
                MutableComponent no = Component.m_237115_((String)"for.no");
                if (genome.getActiveValue(ButterflyChromosomes.NEVER_SLEEPS)) {
                    nocturnal0 = diurnal0 = yes;
                } else {
                    nocturnal0 = primaryAllele.isNocturnal() ? yes : no;
                    MutableComponent mutableComponent = diurnal0 = !primaryAllele.isNocturnal() ? yes : no;
                }
                if (genome.getActiveValue(ButterflyChromosomes.NEVER_SLEEPS)) {
                    nocturnal1 = diurnal1 = yes;
                } else {
                    nocturnal1 = secondaryAllele.isNocturnal() ? yes : no;
                    diurnal1 = !secondaryAllele.isNocturnal() ? yes : no;
                }
                textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.diurnal"), 12);
                textLayout.drawLine(transform, (Component)diurnal0, 90, GuiAlyzer.getColorCoding(false));
                textLayout.drawLine(transform, (Component)diurnal1, 155, GuiAlyzer.getColorCoding(false));
                textLayout.newLine();
                textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.nocturnal"), 12);
                textLayout.drawLine(transform, (Component)nocturnal0, 90, GuiAlyzer.getColorCoding(false));
                textLayout.drawLine(transform, (Component)nocturnal1, 155, GuiAlyzer.getColorCoding(false));
                textLayout.newLine();
                MutableComponent primary = genome.getActiveValue(ButterflyChromosomes.TOLERATES_RAIN) ? yes : no;
                MutableComponent secondary = genome.getInactiveValue(ButterflyChromosomes.TOLERATES_RAIN) ? yes : no;
                guiAlyzer.drawRow(transform, (Component)Component.m_237115_((String)"for.gui.flyer"), (Component)primary, (Component)secondary, (IIndividual)individual, ButterflyChromosomes.TOLERATES_RAIN);
                textLayout.newLine();
                primary = genome.getActiveValue(ButterflyChromosomes.FIREPROOF) ? yes : no;
                secondary = genome.getInactiveValue(ButterflyChromosomes.FIREPROOF) ? yes : no;
                guiAlyzer.drawRow(transform, (Component)Component.m_237115_((String)"for.gui.fireresist"), (Component)primary, (Component)secondary, (IIndividual)individual, ButterflyChromosomes.FIREPROOF);
                textLayout.endPage(transform);
            });
        }
    }

    @Override
    public void drawAnalyticsPage3(PoseStack transform, Screen gui, ItemStack stack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            IIndividualHandlerItem.ifPresent(stack, individual -> {
                IGenome genome = individual.getGenome();
                TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
                WidgetManager widgetManager = guiAlyzer.getWidgetManager();
                textLayout.startPage(transform, 12, 90, 155);
                textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.loot.butterfly").m_130946_(":"), 12);
                textLayout.newLine();
                int x = 12;
                for (IProduct product : genome.getActiveValue(ButterflyChromosomes.SPECIES).getButterflyLoot()) {
                    widgetManager.add(new ItemStackWidget(widgetManager, x, textLayout.getLineY(), product.createStack()));
                    if ((x += 18) <= 148) continue;
                    x = 12;
                    textLayout.newLine();
                }
                textLayout.newLine();
                textLayout.newLine();
                textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.loot.caterpillar").m_130946_(":"), 12);
                textLayout.newLine();
                x = 12;
                for (IProduct product : genome.getActiveValue(ButterflyChromosomes.SPECIES).getCaterpillarProducts()) {
                    widgetManager.add(new ItemStackWidget(widgetManager, x, textLayout.getLineY(), product.createStack()));
                    if ((x += 18) <= 148) continue;
                    x = 12;
                    textLayout.newLine();
                }
                textLayout.newLine();
                textLayout.newLine();
                textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.loot.cocoon").m_130946_(":"), 12);
                textLayout.newLine();
                x = 12;
                for (IProduct product : genome.getActiveValue(ButterflyChromosomes.COCOON).getProducts()) {
                    widgetManager.add(new ItemStackWidget(widgetManager, x, textLayout.getLineY(), product.createStack()));
                    if ((x += 18) <= 148) continue;
                    x = 12;
                    textLayout.newLine();
                }
                textLayout.endPage(transform);
            });
        }
    }

    @Override
    public Map<ISpecies<?>, ItemStack> getIconStacks() {
        return this.iconStacks;
    }

    @Override
    public List<String> getHints() {
        return GuiForestry.HINTS.get((Object)"flutterlyzer");
    }
}

