/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.genetics.ClimateHelper;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.alleles.ButterflyChromosomes;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.gatgets.DatabaseMode;
import forestry.api.genetics.gatgets.IDatabaseTab;
import forestry.api.lepidopterology.ForestryButterflySpecies;
import forestry.api.lepidopterology.genetics.ButterflyLifeStage;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.DatabaseElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.utils.SpeciesUtil;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class ButterflyDatabaseTab
implements IDatabaseTab<IButterfly> {
    private final DatabaseMode mode;

    ButterflyDatabaseTab(DatabaseMode mode) {
        this.mode = mode;
    }

    @Override
    public DatabaseMode getMode() {
        return this.mode;
    }

    @Override
    public void createElements(DatabaseElement database, IButterfly butterfly, ILifeStage stage, ItemStack stack) {
        MutableComponent nocturnalSecond;
        MutableComponent diurnalSecond;
        MutableComponent nocturnalFirst;
        MutableComponent diurnalFirst;
        IButterflySpecies activeSpecies = butterfly.getGenome().getActiveValue(ButterflyChromosomes.SPECIES);
        IButterflySpecies inactiveSpecies = butterfly.getGenome().getInactiveValue(ButterflyChromosomes.SPECIES);
        database.label((Component)Component.m_237115_((String)("for.gui.database.tab." + (this.mode == DatabaseMode.ACTIVE ? "active" : "inactive") + "_species.name")), Alignment.TOP_CENTER, GuiElementFactory.INSTANCE.databaseTitle);
        database.addLine((Component)Component.m_237115_((String)"for.gui.species"), ButterflyChromosomes.SPECIES);
        database.addLine((Component)Component.m_237115_((String)"for.gui.size"), ButterflyChromosomes.SIZE);
        database.addLine((Component)Component.m_237115_((String)"for.gui.lifespan"), ButterflyChromosomes.LIFESPAN);
        database.addLine((Component)Component.m_237115_((String)"for.gui.speed"), ButterflyChromosomes.SPEED);
        database.addLine((Component)Component.m_237115_((String)"for.gui.metabolism"), ButterflyChromosomes.METABOLISM);
        database.addFertilityLine((Component)Component.m_237115_((String)"for.gui.fertility"), ButterflyChromosomes.FERTILITY, 8);
        database.addLine((Component)Component.m_237115_((String)"for.gui.flowers"), ButterflyChromosomes.FLOWER_TYPE);
        database.addLine((Component)Component.m_237115_((String)"for.gui.effect"), ButterflyChromosomes.EFFECT);
        Function<Boolean, Component> toleranceText = a -> {
            IButterflySpecies species = a != false ? activeSpecies : inactiveSpecies;
            return ClimateHelper.toDisplay(species.getTemperature());
        };
        database.addLine((Component)Component.m_237115_((String)"for.gui.climate"), toleranceText, ButterflyChromosomes.TEMPERATURE_TOLERANCE);
        database.addToleranceLine(ButterflyChromosomes.TEMPERATURE_TOLERANCE);
        database.addLine((Component)Component.m_237115_((String)"for.gui.humidity"), toleranceText, ButterflyChromosomes.HUMIDITY_TOLERANCE);
        database.addToleranceLine(ButterflyChromosomes.HUMIDITY_TOLERANCE);
        MutableComponent yes = Component.m_237115_((String)"for.yes");
        MutableComponent no = Component.m_237115_((String)"for.no");
        if (butterfly.getGenome().getActiveValue(ButterflyChromosomes.NEVER_SLEEPS)) {
            nocturnalFirst = diurnalFirst = yes;
        } else {
            nocturnalFirst = activeSpecies.isNocturnal() ? yes : no;
            MutableComponent mutableComponent = diurnalFirst = !activeSpecies.isNocturnal() ? yes : no;
        }
        if (butterfly.getGenome().getInactiveValue(ButterflyChromosomes.NEVER_SLEEPS)) {
            nocturnalSecond = diurnalSecond = yes;
        } else {
            nocturnalSecond = inactiveSpecies.isNocturnal() ? yes : no;
            diurnalSecond = !inactiveSpecies.isNocturnal() ? yes : no;
        }
        database.addLine((Component)Component.m_237115_((String)"for.gui.diurnal"), arg_0 -> ButterflyDatabaseTab.lambda$createElements$1((Component)diurnalFirst, (Component)diurnalSecond, arg_0), false);
        database.addLine((Component)Component.m_237115_((String)"for.gui.nocturnal"), arg_0 -> ButterflyDatabaseTab.lambda$createElements$2((Component)nocturnalFirst, (Component)nocturnalSecond, arg_0), false);
        Function<Boolean, Component> flyer = arg_0 -> ButterflyDatabaseTab.lambda$createElements$3(butterfly, (Component)yes, (Component)no, arg_0);
        database.addLine((Component)Component.m_237115_((String)"for.gui.flyer"), flyer, (IChromosome)ButterflyChromosomes.TOLERATES_RAIN);
        Function<Boolean, Component> fireResist = arg_0 -> ButterflyDatabaseTab.lambda$createElements$4(butterfly, (Component)yes, (Component)no, arg_0);
        database.addLine((Component)Component.m_237115_((String)"for.gui.fireresist"), fireResist, (IChromosome)ButterflyChromosomes.FIREPROOF);
    }

    @Override
    public ItemStack getIconStack() {
        return ((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).createStack(ForestryButterflySpecies.BLUE_WING, (ILifeStage)(this.mode == DatabaseMode.ACTIVE ? ButterflyLifeStage.BUTTERFLY : ButterflyLifeStage.CATERPILLAR));
    }

    private static /* synthetic */ Component lambda$createElements$4(IButterfly butterfly, Component yes, Component no, Boolean active) {
        boolean fireResistant = active != false ? butterfly.getGenome().getActiveValue(ButterflyChromosomes.FIREPROOF) : butterfly.getGenome().getInactiveValue(ButterflyChromosomes.FIREPROOF);
        return fireResistant ? yes : no;
    }

    private static /* synthetic */ Component lambda$createElements$3(IButterfly butterfly, Component yes, Component no, Boolean active) {
        boolean tolerantFlyer = active != false ? butterfly.getGenome().getActiveValue(ButterflyChromosomes.TOLERATES_RAIN) : butterfly.getGenome().getInactiveValue(ButterflyChromosomes.TOLERATES_RAIN);
        return tolerantFlyer ? yes : no;
    }

    private static /* synthetic */ Component lambda$createElements$2(Component nocturnalFirst, Component nocturnalSecond, Boolean a) {
        return a != false ? nocturnalFirst : nocturnalSecond;
    }

    private static /* synthetic */ Component lambda$createElements$1(Component diurnalFirst, Component diurnalSecond, Boolean a) {
        return a != false ? diurnalFirst : diurnalSecond;
    }
}

