/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.core.IProduct;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.alleles.ButterflyChromosomes;
import forestry.api.genetics.gatgets.IDatabaseTab;
import forestry.api.lepidopterology.ForestryButterflySpecies;
import forestry.api.lepidopterology.genetics.ButterflyLifeStage;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.DatabaseElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.ItemElement;
import forestry.core.gui.elements.layouts.FlexLayout;
import forestry.core.gui.elements.layouts.LayoutHelper;
import forestry.core.utils.SpeciesUtil;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class ButterflyProductsTab
implements IDatabaseTab<IButterfly> {
    @Override
    public void createElements(DatabaseElement container, IButterfly individual, ILifeStage stage, ItemStack itemStack) {
        List<IProduct> cocoonLoot;
        List<IProduct> caterpillarLoot;
        LayoutHelper groupHelper = container.layoutHelper((x, y) -> GuiElementFactory.horizontal(18, 2, FlexLayout.LEFT_MARGIN), 90, 0);
        List<IProduct> butterflyLoot = individual.getGenome().getActiveValue(ButterflyChromosomes.SPECIES).getButterflyLoot();
        if (!butterflyLoot.isEmpty()) {
            container.translated("for.gui.loot.butterfly", new Object[0]).setAlign(Alignment.TOP_CENTER);
            butterflyLoot.forEach(stack -> groupHelper.add(new ItemElement(0, 0, stack.createStack())));
            groupHelper.finish();
        }
        if (!(caterpillarLoot = individual.getGenome().getActiveValue(ButterflyChromosomes.SPECIES).getCaterpillarProducts()).isEmpty()) {
            container.translated("for.gui.loot.caterpillar", new Object[0]).setAlign(Alignment.TOP_CENTER);
            caterpillarLoot.forEach(stack -> groupHelper.add(new ItemElement(0, 0, stack.createStack())));
            groupHelper.finish();
        }
        if (!(cocoonLoot = individual.getGenome().getActiveValue(ButterflyChromosomes.COCOON).getProducts()).isEmpty()) {
            container.translated("for.gui.loot.cocoon", new Object[0]).setAlign(Alignment.TOP_CENTER);
            cocoonLoot.forEach(stack -> groupHelper.add(new ItemElement(0, 0, stack.createStack())));
            groupHelper.finish();
        }
    }

    @Override
    public ItemStack getIconStack() {
        return ((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).createStack(ForestryButterflySpecies.AURORA, (ILifeStage)ButterflyLifeStage.SERUM);
    }
}

