/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import forestry.api.ForestryConstants;
import forestry.api.client.IForestryClientApi;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.alleles.ButterflyChromosomes;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.core.models.AbstractBakedModel;
import forestry.core.models.TRSRBakedModel;
import forestry.core.utils.ResourceUtil;
import forestry.core.utils.SpeciesUtil;
import it.unimi.dsi.fastutil.floats.FloatObjectPair;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.SeparateTransformsModel;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;

public class ButterflyItemModel
extends AbstractBakedModel {
    private final IdentityHashMap<IButterflySpecies, BakedModel> subModels;
    private final Cache<FloatObjectPair<String>, BakedModel> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    public ButterflyItemModel(IdentityHashMap<IButterflySpecies, BakedModel> subModels) {
        this.subModels = subModels;
    }

    @Override
    protected ItemOverrides createOverrides() {
        return new OverrideList();
    }

    private class OverrideList
    extends ItemOverrides {
        private OverrideList() {
        }

        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int p_173469_) {
            IIndividual individual = Objects.requireNonNull(IIndividualHandlerItem.getIndividual(stack));
            IGenome genome = individual.getGenome();
            IButterflySpecies species = genome.getActiveValue(ButterflyChromosomes.SPECIES);
            float size = genome.getActiveValue(ButterflyChromosomes.SIZE);
            try {
                return (BakedModel)ButterflyItemModel.this.cache.get((Object)FloatObjectPair.of((float)size, (Object)species.id().m_135815_()), () -> new SeparateTransformsModel.Baked(false, true, false, ResourceUtil.getMissingTexture(), ItemOverrides.f_111734_, (BakedModel)new TRSRBakedModel(ButterflyItemModel.this.subModels.get(species), 0.0f, 0.0f, 0.0f, size), ImmutableMap.of()));
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private ImmutableMap<ItemTransforms.TransformType, Transformation> getTransformations(float size) {
            float scale = 0.0625f;
            float sSize = size * 1.15f;
            Vector3f scaledSize = new Vector3f(sSize, sSize, sSize);
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)5);
            builder.put((Object)ItemTransforms.TransformType.FIXED, (Object)new Transformation(new Vector3f(scale * 0.5f, scale - size / 0.75f * scale, scale * 1.25f), null, scaledSize, null));
            builder.put((Object)ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)new Transformation(new Vector3f(0.0f, -scale * 4.75f, 0.0f), null, scaledSize, null));
            builder.put((Object)ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)new Transformation(new Vector3f(0.0f, -scale * 4.75f, 0.0f), null, scaledSize, null));
            builder.put((Object)ItemTransforms.TransformType.GUI, (Object)new Transformation(new Vector3f(0.0f, -scale, 0.0f), new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 90.0f, true), scaledSize, null));
            builder.put((Object)ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), null, scaledSize, null));
            return builder.build();
        }
    }

    public static class Loader
    implements IGeometryLoader<Geometry> {
        public Geometry read(JsonObject modelContents, JsonDeserializationContext context) throws JsonParseException {
            IdentityHashMap<IButterflySpecies, ResourceLocation> subModels = new IdentityHashMap<IButterflySpecies, ResourceLocation>();
            for (IButterflySpecies species : SpeciesUtil.getAllButterflySpecies()) {
                Pair<ResourceLocation, ResourceLocation> pair = IForestryClientApi.INSTANCE.getButterflyManager().getTextures(species);
                subModels.put(species, (ResourceLocation)pair.getFirst());
            }
            return new Geometry(subModels);
        }
    }

    public record Geometry(IdentityHashMap<IButterflySpecies, ResourceLocation> subModels) implements IUnbakedGeometry<Geometry>
    {
        public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
            UnbakedModel modelButterfly = bakery.m_119341_(ForestryConstants.forestry("item/butterfly"));
            if (!(modelButterfly instanceof BlockModel)) {
                return null;
            }
            BlockModel modelBlock = (BlockModel)modelButterfly;
            ResourceLocation parentLocation = modelBlock.getParentLocation();
            List elements = modelBlock.m_111436_();
            IdentityHashMap<IButterflySpecies, BakedModel> subModelBuilder = new IdentityHashMap<IButterflySpecies, BakedModel>();
            for (Map.Entry<IButterflySpecies, ResourceLocation> subModel : this.subModels.entrySet()) {
                IButterflySpecies identifier = subModel.getKey();
                ResourceLocation texture = subModel.getValue();
                BlockModel model = new BlockModel(parentLocation, elements, (Map)ImmutableMap.of((Object)"butterfly", (Object)Either.left((Object)new Material(InventoryMenu.f_39692_, texture))), modelBlock.f_111424_, modelBlock.m_111479_(), modelBlock.m_111491_(), modelBlock.m_111484_());
                ResourceLocation location = ForestryConstants.forestry("item/butterfly");
                SimpleModelState transform = ResourceUtil.loadTransform(ForestryConstants.forestry("item/butterfly"));
                subModelBuilder.put(identifier, model.m_111449_(bakery, model, spriteGetter, (ModelState)transform, location, true));
            }
            return new ButterflyItemModel(subModelBuilder);
        }

        public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.subModels.values().stream().map(location -> new Material(InventoryMenu.f_39692_, location)).collect(Collectors.toSet());
        }
    }
}

