/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import forestry.api.core.INbtWritable;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.IMailAddress;
import forestry.core.utils.PlayerUtil;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import org.apache.commons.lang3.StringUtils;

public class MailAddress
implements INbtWritable,
IMailAddress {
    private static final GameProfile invalidGameProfile = new GameProfile(new UUID(0L, 0L), "");
    private final EnumAddressee type;
    private final GameProfile gameProfile;

    public MailAddress() {
        this.type = EnumAddressee.PLAYER;
        this.gameProfile = invalidGameProfile;
    }

    public MailAddress(GameProfile gameProfile) {
        Preconditions.checkNotNull((Object)gameProfile, (Object)"gameProfile must not be null");
        this.type = EnumAddressee.PLAYER;
        this.gameProfile = gameProfile;
    }

    public MailAddress(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"name must not be blank");
        this.type = EnumAddressee.TRADER;
        this.gameProfile = new GameProfile(null, name);
    }

    public MailAddress(CompoundTag nbt) {
        CompoundTag profileTag;
        EnumAddressee type = null;
        GameProfile gameProfile = invalidGameProfile;
        if (nbt.m_128441_("TP")) {
            String typeName = nbt.m_128461_("TP");
            type = EnumAddressee.fromString(typeName);
        }
        if (type == null) {
            type = EnumAddressee.PLAYER;
            gameProfile = invalidGameProfile;
        } else if (nbt.m_128441_("profile") && (gameProfile = NbtUtils.m_129228_((CompoundTag)(profileTag = nbt.m_128469_("profile")))) == null) {
            gameProfile = invalidGameProfile;
        }
        this.type = type;
        this.gameProfile = gameProfile;
    }

    @Override
    public EnumAddressee getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.gameProfile.getName();
    }

    @Override
    public boolean isValid() {
        return this.gameProfile.getName() != null && !PlayerUtil.isSameGameProfile(this.gameProfile, invalidGameProfile);
    }

    @Override
    public GameProfile getPlayerProfile() {
        if (this.type != EnumAddressee.PLAYER) {
            return invalidGameProfile;
        }
        return this.gameProfile;
    }

    public int hashCode() {
        return this.gameProfile.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MailAddress)) {
            return false;
        }
        MailAddress address = (MailAddress)o;
        return PlayerUtil.isSameGameProfile(address.gameProfile, this.gameProfile);
    }

    public String toString() {
        String name = this.getName().toLowerCase(Locale.ENGLISH);
        if (this.getType() == EnumAddressee.PLAYER) {
            return this.type + "-" + name + "-" + this.gameProfile.getId();
        }
        return this.type + "-" + name;
    }

    @Override
    public CompoundTag write(CompoundTag compoundNBT) {
        compoundNBT.m_128359_("TP", this.type.toString());
        if (this.gameProfile != invalidGameProfile) {
            CompoundTag profileNbt = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)profileNbt, (GameProfile)this.gameProfile);
            compoundNBT.m_128365_("profile", (Tag)profileNbt);
        }
        return compoundNBT;
    }
}

