/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.mail.EnumPostage;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.IPostalState;
import forestry.api.mail.IStamps;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.mail.EnumDeliveryState;
import forestry.mail.features.MailItems;
import forestry.mail.items.EnumStampDefinition;
import java.util.LinkedHashMap;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class PostOffice
extends SavedData
implements IPostOffice {
    public static final String SAVE_NAME = "forestry_mail";
    private final int[] collectedPostage = new int[EnumPostage.values().length];
    private LinkedHashMap<IMailAddress, ITradeStation> activeTradeStations = new LinkedHashMap();

    public PostOffice() {
    }

    public PostOffice(CompoundTag tag) {
        for (int i = 0; i < this.collectedPostage.length; ++i) {
            if (!tag.m_128441_("CPS" + i)) continue;
            this.collectedPostage[i] = tag.m_128451_("CPS" + i);
        }
    }

    public void setWorld(ServerLevel world) {
        this.refreshActiveTradeStations(world);
    }

    public CompoundTag m_7176_(CompoundTag compoundNBT) {
        for (int i = 0; i < this.collectedPostage.length; ++i) {
            compoundNBT.m_128405_("CPS" + i, this.collectedPostage[i]);
        }
        return compoundNBT;
    }

    public LinkedHashMap<IMailAddress, ITradeStation> getActiveTradeStations(Level world) {
        return this.activeTradeStations;
    }

    private void refreshActiveTradeStations(ServerLevel world) {
    }

    @Override
    public void registerTradeStation(ITradeStation trade) {
        if (!this.activeTradeStations.containsKey(trade.getAddress())) {
            this.activeTradeStations.put(trade.getAddress(), trade);
        }
    }

    @Override
    public void deregisterTradeStation(ITradeStation trade) {
        this.activeTradeStations.remove(trade.getAddress());
    }

    @Override
    public ItemStack getAnyStamp(int max) {
        return this.getAnyStamp(EnumPostage.values(), max);
    }

    @Override
    public ItemStack getAnyStamp(EnumPostage postage, int max) {
        return this.getAnyStamp(new EnumPostage[]{postage}, max);
    }

    @Override
    public ItemStack getAnyStamp(EnumPostage[] postages, int max) {
        for (EnumPostage postage : postages) {
            int collected = Math.min(max, this.collectedPostage[postage.ordinal()]);
            int n = postage.ordinal();
            this.collectedPostage[n] = this.collectedPostage[n] - collected;
            if (collected <= 0) continue;
            EnumStampDefinition stampDefinition = EnumStampDefinition.getFromPostage(postage);
            return MailItems.STAMPS.stack(stampDefinition, collected);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public IPostalState lodgeLetter(ServerLevel world, ItemStack itemstack, boolean doLodge) {
        IPostalCarrier carrier;
        ILetter letter = PostManager.postRegistry.getLetter(itemstack);
        if (letter == null) {
            return EnumDeliveryState.NOT_MAILABLE;
        }
        if (letter.isProcessed()) {
            return EnumDeliveryState.ALREADY_MAILED;
        }
        if (!letter.isPostPaid()) {
            return EnumDeliveryState.NOT_POSTPAID;
        }
        if (!letter.isMailable()) {
            return EnumDeliveryState.NOT_MAILABLE;
        }
        IPostalState state = EnumDeliveryState.NOT_MAILABLE;
        IMailAddress address = letter.getRecipient();
        if (address != null && (carrier = PostManager.postRegistry.getCarrier(address.getType())) != null) {
            state = carrier.deliverLetter(world, this, address, itemstack, doLodge);
        }
        if (!state.isOk()) {
            return state;
        }
        this.collectPostage(letter.getPostage());
        this.m_77762_();
        return EnumDeliveryState.OK;
    }

    @Override
    public void collectPostage(NonNullList<ItemStack> stamps) {
        for (ItemStack stamp : stamps) {
            if (stamp == null || !(stamp.m_41720_() instanceof IStamps)) continue;
            EnumPostage postage = ((IStamps)stamp.m_41720_()).getPostage(stamp);
            int n = postage.ordinal();
            this.collectedPostage[n] = this.collectedPostage[n] + stamp.m_41613_();
        }
    }
}

