/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.ForestryConstants;
import forestry.api.client.IForestryClientApi;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.IPostalState;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.PlayerUtil;
import forestry.mail.EnumDeliveryState;
import forestry.mail.POBox;
import forestry.mail.PostRegistry;
import forestry.mail.network.packets.PacketPOBoxInfoResponse;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PostalCarrier
implements IPostalCarrier {
    private final ResourceLocation iconID;
    private final EnumAddressee type;

    public PostalCarrier(EnumAddressee type) {
        this.iconID = ForestryConstants.forestry("mail/carrier." + type);
        this.type = type;
    }

    @Override
    public EnumAddressee getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return Component.m_237115_((String)("for.gui.addressee." + this.type)).getString();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getSprite() {
        return IForestryClientApi.INSTANCE.getTextureManager().getSprite(this.iconID);
    }

    @Override
    public IPostalState deliverLetter(ServerLevel world, IPostOffice office, IMailAddress recipient, ItemStack letterStack, boolean doDeliver) {
        if (this.type == EnumAddressee.TRADER) {
            return PostalCarrier.handleTradeLetter(world, recipient, letterStack, doDeliver);
        }
        return PostalCarrier.storeInPOBox(world, recipient, letterStack);
    }

    private static IPostalState handleTradeLetter(ServerLevel world, IMailAddress recipient, ItemStack letterStack, boolean doLodge) {
        ITradeStation trade = PostManager.postRegistry.getTradeStation(world, recipient);
        if (trade == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        return trade.handleLetter(world, recipient, letterStack, doLodge);
    }

    private static EnumDeliveryState storeInPOBox(ServerLevel world, IMailAddress recipient, ItemStack letterStack) {
        POBox pobox = PostRegistry.getPOBox(world, recipient);
        if (pobox == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        if (!pobox.storeLetter(letterStack.m_41777_())) {
            return EnumDeliveryState.MAILBOX_FULL;
        }
        Player player = PlayerUtil.getPlayer((Level)world, recipient.getPlayerProfile());
        if (player instanceof ServerPlayer) {
            NetworkUtil.sendToPlayer(new PacketPOBoxInfoResponse(pobox.getPOBoxInfo()), (ServerPlayer)player);
        }
        return EnumDeliveryState.OK;
    }
}

