/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.ITradeStationInfo;
import forestry.api.mail.PostManager;
import forestry.core.commands.CommandHelpers;
import forestry.core.utils.StringUtil;
import forestry.mail.MailAddress;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CommandMail {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"mail").then(CommandMailTrades.register())).then(CommandMailVirtualize.register());
    }

    public static class CommandMailTrades {
        public static ArgumentBuilder<CommandSourceStack, ?> register() {
            return Commands.m_82127_((String)"trades").executes(CommandMailTrades::execute);
        }

        public static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ServerLevel world = (ServerLevel)player.f_19853_;
            for (ITradeStation trade : PostManager.postRegistry.getPostOffice(world).getActiveTradeStations((Level)world).values()) {
                CommandHelpers.sendChatMessage((CommandSourceStack)context.getSource(), CommandMailTrades.makeTradeListEntry(trade.getTradeInfo()));
            }
            return 1;
        }

        private static Component makeTradeListEntry(ITradeStationInfo info) {
            ChatFormatting formatting = info.state().isOk() ? ChatFormatting.GREEN : ChatFormatting.RED;
            Object tradegood = "[ ? ]";
            if (!info.tradegood().m_41619_()) {
                tradegood = info.tradegood().m_41613_() + "x" + info.tradegood().m_41786_();
            }
            String demand = "[ ? ]";
            if (!info.required().isEmpty()) {
                demand = "";
                for (ItemStack dmd : info.required()) {
                    demand = StringUtil.append(", ", demand, dmd.m_41613_() + "x" + dmd.m_41786_());
                }
            }
            return Component.m_237113_((String)String.format("%s%-12s | %-20s | %s", formatting, info.address().getName(), tradegood, demand));
        }
    }

    public static class CommandMailVirtualize {
        public static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.m_82127_((String)"virtualize").requires(CommandHelpers.ADMIN)).executes(CommandMailVirtualize::execute);
        }

        public static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            MailAddress address;
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            Level world = player.m_20193_();
            ITradeStation trade = PostManager.postRegistry.getTradeStation((ServerLevel)world, address = new MailAddress(player.m_36316_()));
            if (trade == null) {
                Style red = Style.f_131099_;
                red.m_131140_(ChatFormatting.RED);
                CommandHelpers.sendLocalizedChatMessage((CommandSourceStack)context.getSource(), red, "for.chat.command.forestry.mail.virtualize.no_tradestation", player.m_5446_());
                return 0;
            }
            trade.setVirtual(!trade.isVirtual());
            Style green = Style.f_131099_;
            green.m_131140_(ChatFormatting.GREEN);
            CommandHelpers.sendLocalizedChatMessage((CommandSourceStack)context.getSource(), green, "for.chat.command.forestry.mail.virtualize.set", trade.getAddress().getName(), trade.isVirtual());
            return 1;
        }
    }
}

