/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.Forestry;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.ITradeStationInfo;
import forestry.api.mail.PostManager;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.slots.SlotFiltered;
import forestry.core.utils.NetworkUtil;
import forestry.mail.features.MailMenuTypes;
import forestry.mail.gui.ILetterInfoReceiver;
import forestry.mail.inventory.ItemInventoryLetter;
import forestry.mail.network.packets.PacketLetterInfoResponsePlayer;
import forestry.mail.network.packets.PacketLetterInfoResponseTrader;
import forestry.mail.network.packets.PacketLetterTextSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerLetter
extends ContainerItemInventory<ItemInventoryLetter>
implements ILetterInfoReceiver {
    private EnumAddressee carrierType = EnumAddressee.PLAYER;
    @Nullable
    private ITradeStationInfo tradeInfo = null;

    public static ContainerLetter fromNetwork(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        InteractionHand hand = extraData.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        Player player = playerInv.f_35978_;
        ItemInventoryLetter inv = new ItemInventoryLetter(player, player.m_21120_(hand));
        return new ContainerLetter(windowId, player, inv);
    }

    public ContainerLetter(int windowId, Player player, ItemInventoryLetter inventory) {
        super(windowId, inventory, player.m_150109_(), 17, 145, MailMenuTypes.LETTER.menuType());
        ILetter letter;
        IMailAddress recipient;
        int i;
        for (i = 0; i < 4; ++i) {
            this.m_38897_(new SlotFiltered(inventory, 18 + i, 150, 14 + i * 19).setStackLimit(1));
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new SlotFiltered(inventory, 0 + j + i * 9, 17 + j * 18, 98 + i * 18));
            }
        }
        if (!player.f_19853_.f_46443_ && inventory.getLetter().isProcessed()) {
            inventory.onLetterOpened();
        }
        if ((recipient = (letter = inventory.getLetter()).getRecipient()) != null) {
            this.carrierType = recipient.getType();
        }
    }

    public void m_6877_(Player PlayerEntity) {
        ILetter letter;
        if (!PlayerEntity.f_19853_.f_46443_ && !(letter = ((ItemInventoryLetter)this.inventory).getLetter()).isProcessed()) {
            IMailAddress sender = PostManager.postRegistry.getMailAddress(PlayerEntity.m_36316_());
            letter.setSender(sender);
        }
        ((ItemInventoryLetter)this.inventory).onLetterClosed();
        super.m_6877_(PlayerEntity);
    }

    public ILetter getLetter() {
        return ((ItemInventoryLetter)this.inventory).getLetter();
    }

    public void setCarrierType(EnumAddressee type) {
        this.carrierType = type;
    }

    public EnumAddressee getCarrierType() {
        return this.carrierType;
    }

    public void advanceCarrierType() {
        Iterator<IPostalCarrier> it = PostManager.postRegistry.getRegisteredCarriers().values().iterator();
        while (it.hasNext() && !it.next().getType().equals((Object)this.carrierType)) {
        }
        IPostalCarrier postal = it.hasNext() ? it.next() : PostManager.postRegistry.getRegisteredCarriers().values().iterator().next();
        this.setCarrierType(postal.getType());
    }

    public void handleRequestLetterInfo(Player player, String recipientName, EnumAddressee type) {
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            Forestry.LOGGER.error("Could not get server");
            return;
        }
        IMailAddress recipient = ContainerLetter.getRecipient(server, recipientName, type);
        this.getLetter().setRecipient(recipient);
        if (recipient == null || recipient.getType() == EnumAddressee.TRADER) {
            this.updateTradeInfo(player.f_19853_, recipient);
        }
        if (type == EnumAddressee.PLAYER) {
            if (recipient != null) {
                NetworkUtil.sendToPlayer(new PacketLetterInfoResponsePlayer(recipient), (ServerPlayer)player);
            }
        } else {
            NetworkUtil.sendToPlayer(new PacketLetterInfoResponseTrader(this.tradeInfo), (ServerPlayer)player);
        }
    }

    @Nullable
    private static IMailAddress getRecipient(MinecraftServer minecraftServer, String recipientName, EnumAddressee type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case EnumAddressee.PLAYER -> minecraftServer.m_129927_().m_10996_(recipientName).map(PostManager.postRegistry::getMailAddress).orElse(null);
            case EnumAddressee.TRADER -> PostManager.postRegistry.getMailAddress(recipientName);
        };
    }

    @Nullable
    public IMailAddress getRecipient() {
        return this.getLetter().getRecipient();
    }

    public String getText() {
        return this.getLetter().getText();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setText(String text) {
        this.getLetter().setText(text);
        NetworkUtil.sendToServer(new PacketLetterTextSet(text));
    }

    public void handleSetText(String text) {
        this.getLetter().setText(text);
    }

    private void updateTradeInfo(Level world, @Nullable IMailAddress address) {
        if (world.f_46443_) {
            return;
        }
        if (address == null) {
            this.setTradeInfo(null);
            return;
        }
        ITradeStation station = PostManager.postRegistry.getTradeStation((ServerLevel)world, address);
        if (station == null) {
            this.setTradeInfo(null);
            return;
        }
        this.setTradeInfo(station.getTradeInfo());
    }

    @Override
    public void handleLetterInfoUpdate(EnumAddressee type, @Nullable IMailAddress address, @Nullable ITradeStationInfo tradeInfo) {
        this.carrierType = type;
        if (type == EnumAddressee.PLAYER) {
            this.getLetter().setRecipient(address);
        } else if (type == EnumAddressee.TRADER) {
            this.setTradeInfo(tradeInfo);
        }
    }

    @Nullable
    public ITradeStationInfo getTradeInfo() {
        return this.tradeInfo;
    }

    private void setTradeInfo(@Nullable ITradeStationInfo info) {
        this.tradeInfo = info;
        if (this.tradeInfo == null) {
            this.getLetter().setRecipient(null);
        } else {
            this.getLetter().setRecipient(this.tradeInfo.address());
        }
    }
}

