/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.ITradeStationInfo;
import forestry.core.config.SessionVars;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import forestry.mail.gui.ContainerCatalogue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class GuiCatalogue
extends GuiForestry<ContainerCatalogue> {
    private static final String boldUnderline = ChatFormatting.BOLD.toString() + ChatFormatting.UNDERLINE;
    private Button buttonFilter;
    private Button buttonUse;
    private final List<ItemStackWidget> tradeInfoWidgets = new ArrayList<ItemStackWidget>();

    public GuiCatalogue(ContainerCatalogue container, Inventory inv, Component title) {
        super(new ResourceLocation("textures/gui/book.png"), container, inv, title);
        this.f_97726_ = 192;
        this.f_97727_ = 192;
        this.buttonFilter = new Button(this.f_96543_ / 2 - 44, this.f_97736_ + 150, 42, 20, (Component)Component.m_237115_((String)"for.gui.mail.filter.all"), b -> this.actionPerformed(4));
        this.buttonUse = new Button(this.f_96543_ / 2, this.f_97736_ + 150, 42, 20, (Component)Component.m_237115_((String)"for.gui.mail.address.copy"), b -> this.actionPerformed(5));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.f_169369_.clear();
        Minecraft.m_91087_().f_91068_.m_90926_(true);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 44, this.f_97736_ + 150, 12, 20, (Component)Component.m_237113_((String)">"), b -> this.actionPerformed(2)));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 58, this.f_97736_ + 150, 12, 20, (Component)Component.m_237113_((String)"<"), b -> this.actionPerformed(3)));
        this.buttonFilter = new Button(this.f_96543_ / 2 - 44, this.f_97736_ + 150, 42, 20, (Component)Component.m_237115_((String)"for.gui.mail.filter.all"), b -> this.actionPerformed(4));
        this.m_142416_((GuiEventListener)this.buttonFilter);
        this.buttonUse = new Button(this.f_96543_ / 2, this.f_97736_ + 150, 42, 20, (Component)Component.m_237115_((String)"for.gui.mail.address.copy"), b -> this.actionPerformed(5));
        this.m_142416_((GuiEventListener)this.buttonUse);
    }

    public void m_7861_() {
        Minecraft.m_91087_().f_91068_.m_90926_(false);
        super.m_7861_();
    }

    @Override
    protected void m_7286_(PoseStack transform, float partialTicks, int mouseY, int mouseX) {
        super.m_7286_(transform, partialTicks, mouseY, mouseX);
        Minecraft.m_91087_().f_91062_.m_92883_(transform, String.format("%s / %s", ((ContainerCatalogue)this.f_97732_).getPageNumber(), ((ContainerCatalogue)this.f_97732_).getPageCount()), (float)(this.f_97735_ + this.f_97726_ - 72), (float)(this.f_97736_ + 12), ColourProperties.INSTANCE.get("gui.book"));
        this.clearTradeInfoWidgets();
        ITradeStationInfo tradeInfo = ((ContainerCatalogue)this.f_97732_).getTradeInfo();
        if (tradeInfo != null) {
            this.drawTradePreview(transform, tradeInfo, this.f_97735_ + 38, this.f_97736_ + 30);
            this.buttonUse.f_93624_ = tradeInfo.state().isOk();
        } else {
            this.drawNoTrade(this.f_97735_ + 38, this.f_97736_ + 30);
            this.buttonUse.f_93624_ = false;
        }
        this.buttonFilter.m_93666_((Component)Component.m_237115_((String)("for.gui.mail.filter." + ((ContainerCatalogue)this.f_97732_).getFilterIdent())));
    }

    private void drawNoTrade(int x, int y) {
        Minecraft.m_91087_().f_91062_.m_92857_((FormattedText)Component.m_237115_((String)"for.gui.mail.notrades"), x, y + 18, 119, ColourProperties.INSTANCE.get("gui.book"));
    }

    private void drawTradePreview(PoseStack transform, ITradeStationInfo tradeInfo, int x, int y) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        fontRenderer.m_92883_(transform, boldUnderline + tradeInfo.address().getName(), (float)x, (float)y, ColourProperties.INSTANCE.get("gui.book"));
        fontRenderer.m_92889_(transform, (Component)Component.m_237110_((String)"for.gui.mail.willtrade", (Object[])new Object[]{tradeInfo.owner().getName()}), (float)x, (float)(y + 18), ColourProperties.INSTANCE.get("gui.book"));
        this.addTradeInfoWidget(new ItemStackWidget(this.widgetManager, x - this.f_97735_, y - this.f_97736_ + 28, tradeInfo.tradegood()));
        fontRenderer.m_92889_(transform, (Component)Component.m_237115_((String)"for.gui.mail.tradefor"), (float)x, (float)(y + 46), ColourProperties.INSTANCE.get("gui.book"));
        for (int i = 0; i < tradeInfo.required().size(); ++i) {
            ItemStack itemStack = tradeInfo.required().get(i);
            this.addTradeInfoWidget(new ItemStackWidget(this.widgetManager, x - this.f_97735_ + i * 18, y - this.f_97736_ + 56, itemStack));
        }
        if (tradeInfo.state().isOk()) {
            fontRenderer.m_92857_((FormattedText)((MutableComponent)tradeInfo.state().getDescription()).m_130940_(ChatFormatting.DARK_GREEN), x, y + 82, 119, ColourProperties.INSTANCE.get("gui.book"));
        } else {
            fontRenderer.m_92857_((FormattedText)((MutableComponent)tradeInfo.state().getDescription()).m_130940_(ChatFormatting.DARK_RED), x, y + 82, 119, ColourProperties.INSTANCE.get("gui.book"));
        }
    }

    private void addTradeInfoWidget(ItemStackWidget widget) {
        this.tradeInfoWidgets.add(widget);
        this.widgetManager.add(widget);
    }

    private void clearTradeInfoWidgets() {
        for (Widget widget : this.tradeInfoWidgets) {
            this.widgetManager.remove(widget);
        }
        this.tradeInfoWidgets.clear();
    }

    protected void actionPerformed(int id) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        switch (id) {
            case 0: {
                player.m_6915_();
                break;
            }
            case 2: {
                NetworkUtil.sendToServer(new PacketGuiSelectRequest(0, 0));
                break;
            }
            case 3: {
                NetworkUtil.sendToServer(new PacketGuiSelectRequest(1, 0));
                break;
            }
            case 4: {
                NetworkUtil.sendToServer(new PacketGuiSelectRequest(2, 0));
                break;
            }
            case 5: {
                ITradeStationInfo info = ((ContainerCatalogue)this.f_97732_).getTradeInfo();
                if (info != null) {
                    SessionVars.setStringVar("mail.letter.recipient", info.address().getName());
                    SessionVars.setStringVar("mail.letter.addressee", EnumAddressee.TRADER.toString());
                }
                player.m_6915_();
            }
        }
    }

    @Override
    protected void addLedgers() {
    }
}

