/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.items;

import forestry.api.ForestryTags;
import forestry.api.mail.EnumPostage;
import forestry.core.items.ItemOverlay;
import java.awt.Color;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public enum EnumStampDefinition implements ItemOverlay.IOverlayInfo
{
    P_1("1n", EnumPostage.P_1, ForestryTags.Items.GEMS_APATITE, new Color(4885671), new Color(0xFFFFFF)),
    P_2("2n", EnumPostage.P_2, Items.f_151052_, new Color(15255572), new Color(0xFFFFFF)),
    P_5("5n", EnumPostage.P_5, ForestryTags.Items.INGOTS_TIN, new Color(10225415), new Color(0xFFFFFF)),
    P_10("10n", EnumPostage.P_10, (TagKey<Item>)Tags.Items.INGOTS_GOLD, new Color(8114616), new Color(0xFFFFFF)),
    P_20("20n", EnumPostage.P_20, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, new Color(16748593), new Color(0xFFF7DD)),
    P_50("50n", EnumPostage.P_50, (TagKey<Item>)Tags.Items.GEMS_EMERALD, new Color(6566359), new Color(0xFFF7DD)),
    P_100("100n", EnumPostage.P_100, Items.f_42686_, new Color(14102970), new Color(0xFFF7DD));

    public static final EnumStampDefinition[] VALUES;
    private static final Map<EnumPostage, EnumStampDefinition> postageMap;
    private final String name;
    private final int primaryColor;
    private final int secondaryColor;
    private final Supplier<Ingredient> craftingIngredient;
    private final EnumPostage postage;

    private EnumStampDefinition(String name, EnumPostage postage, TagKey<Item> crafting, Color primaryColor, Color secondaryColor) {
        this(name, postage, () -> Ingredient.m_204132_((TagKey)crafting), primaryColor, secondaryColor);
    }

    private EnumStampDefinition(String name, EnumPostage postage, Item crafting, Color primaryColor, Color secondaryColor) {
        this(name, postage, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{crafting}), primaryColor, secondaryColor);
    }

    private EnumStampDefinition(String name, EnumPostage postage, Supplier<Ingredient> crafting, Color primaryColor, Color secondaryColor) {
        this.name = name;
        this.primaryColor = primaryColor.getRGB();
        this.secondaryColor = secondaryColor.getRGB();
        this.craftingIngredient = crafting;
        this.postage = postage;
    }

    public EnumPostage getPostage() {
        return this.postage;
    }

    public Ingredient getCraftingIngredient() {
        return this.craftingIngredient.get();
    }

    public String m_7912_() {
        return this.name;
    }

    @Override
    public int getPrimaryColor() {
        return this.primaryColor;
    }

    @Override
    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    public static EnumStampDefinition getFromPostage(EnumPostage postage) {
        return postageMap.get((Object)postage);
    }

    static {
        VALUES = EnumStampDefinition.values();
        postageMap = new EnumMap<EnumPostage, EnumStampDefinition>(EnumPostage.class);
        for (EnumStampDefinition stampDefinition : VALUES) {
            postageMap.put(stampDefinition.getPostage(), stampDefinition);
        }
    }
}

