/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.items;

import forestry.api.core.IItemSubtype;
import forestry.api.core.ItemGroups;
import forestry.core.items.ItemWithGui;
import forestry.mail.Letter;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.inventory.ItemInventoryLetter;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemLetter
extends ItemWithGui {
    private Size size;
    private State state;

    public ItemLetter(Size size, State state) {
        super(new Item.Properties().m_41491_(ItemGroups.tabForestry).m_41487_(64));
        this.size = size;
        this.state = state;
    }

    public Size getSize() {
        return this.size;
    }

    public State getState() {
        return this.state;
    }

    public String m_5524_() {
        return "item.forestry.letter";
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        ItemStack heldItem = player.m_21120_(handIn);
        if (heldItem.m_41613_() == 1) {
            return super.m_7203_(worldIn, player, handIn);
        }
        player.m_213846_((Component)Component.m_237115_((String)"for.chat.mail.wrongstacksize"));
        return InteractionResultHolder.m_19100_((Object)heldItem);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemstack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        CompoundTag compoundNBT = itemstack.m_41783_();
        if (compoundNBT == null) {
            list.add((Component)Component.m_237113_((String)"<").m_7220_((Component)Component.m_237115_((String)"for.gui.blank").m_130946_(">")).m_130940_(ChatFormatting.GRAY));
            return;
        }
        Letter letter = new Letter(compoundNBT);
        letter.addTooltip(list);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> stacks) {
        if (this.m_220152_(group) && this.state == State.FRESH && this.size == Size.EMPTY) {
            stacks.add((Object)new ItemStack((ItemLike)this));
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu getContainer(int windowId, Player player, ItemStack heldItem) {
        return new ContainerLetter(windowId, player, new ItemInventoryLetter(player, heldItem));
    }

    public static enum Size implements IItemSubtype
    {
        EMPTY,
        SMALL,
        BIG;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum State implements IItemSubtype
    {
        FRESH,
        STAMPED,
        OPENED,
        EMPTIED;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

