/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.network.packets;

import forestry.api.modules.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.mail.POBoxInfo;
import forestry.mail.gui.GuiMailboxInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record PacketPOBoxInfoResponse(int playerLetters, int tradeLetters) implements IForestryPacketClient
{
    public PacketPOBoxInfoResponse(POBoxInfo info) {
        this(info.playerLetters(), info.tradeLetters());
    }

    @Override
    public ResourceLocation id() {
        return PacketIdClient.POBOX_INFO_RESPONSE;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.playerLetters);
        buffer.writeInt(this.tradeLetters);
    }

    public static PacketPOBoxInfoResponse decode(FriendlyByteBuf buffer) {
        return new PacketPOBoxInfoResponse(buffer.readInt(), buffer.readInt());
    }

    public static void handle(PacketPOBoxInfoResponse msg, Player player) {
        GuiMailboxInfo.INSTANCE.setPOBoxInfo(player, new POBoxInfo(msg.playerLetters, msg.tradeLetters));
    }
}

