/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules;

import forestry.Forestry;
import forestry.modules.features.FeatureProvider;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class ModuleUtil {
    private static final HashMap<Class<?>, Field> MOD_BUS_FIELDS = new HashMap();
    private static final HashMap<String, IEventBus> MOD_BUSES = new HashMap();

    public static void loadFeatureProviders() {
        ModuleUtil.forEachAnnotated(Type.getType(FeatureProvider.class), klass -> Forestry.LOGGER.debug("Loaded feature provider {}", klass));
    }

    static void forEachAnnotated(Type annotationType, Consumer<Class<?>> action) {
        for (ModFileScanData scanData : ModList.get().getAllScanData()) {
            Set annotationData = scanData.getAnnotations();
            for (ModFileScanData.AnnotationData data : annotationData) {
                if (!data.annotationType().equals((Object)annotationType)) continue;
                String className = data.memberName();
                try {
                    Class<?> klass = Class.forName(className);
                    action.accept(klass);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Failed to load annotated member " + className, e);
                }
            }
        }
    }

    public static IEventBus getModBus(String modid) {
        return MOD_BUSES.computeIfAbsent(modid, key -> {
            ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(modid).orElseThrow();
            Field modBusField = MOD_BUS_FIELDS.computeIfAbsent(modContainer.getClass(), type -> {
                for (Class klass = type; klass != ModContainer.class; klass = klass.getSuperclass()) {
                    for (Field field : klass.getDeclaredFields()) {
                        String name = field.getName();
                        if (!name.equals("eventBus") && !name.equals("modBus") || !IEventBus.class.isAssignableFrom(field.getType())) continue;
                        field.setAccessible(true);
                        return field;
                    }
                }
                throw new RuntimeException("Failed to find eventBus or modBus field in mod container: " + type);
            });
            try {
                return (IEventBus)modBusField.get(modContainer);
            }
            catch (ClassCastException | IllegalAccessException e) {
                throw new RuntimeException("Failed to obtain mod-specific event bus for '" + modid + "'", e);
            }
        });
    }
}

