/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.api.core.IBlockSubtype;
import forestry.api.core.IFeatureSubtype;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureGroup;
import forestry.modules.features.IFeatureRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;

public class FeatureBlockGroup<B extends Block, S extends IBlockSubtype>
extends FeatureGroup<Builder<B, S>, FeatureBlock<B, BlockItem>, S> {
    private FeatureBlockGroup(Builder<B, S> builder) {
        super(builder);
    }

    @Override
    protected FeatureBlock<B, BlockItem> createFeature(Builder<B, S> builder, S type) {
        return builder.registry.block(() -> (Block)builder.constructor.apply(type), builder.itemConstructor != null ? block -> builder.itemConstructor.apply(block, type) : null, builder.getIdentifier((IFeatureSubtype)type));
    }

    public Collection<B> getBlocks() {
        ArrayList blocks = new ArrayList(this.featureByType.size());
        for (FeatureBlock value : this.featureByType.values()) {
            blocks.add(value.block());
        }
        return blocks;
    }

    public Collection<BlockItem> getItems() {
        ArrayList<BlockItem> items = new ArrayList<BlockItem>(this.featureByType.size());
        for (FeatureBlock value : this.featureByType.values()) {
            items.add((BlockItem)value.item());
        }
        return items;
    }

    public Block[] blockArray() {
        return this.getBlocks().toArray(new Block[0]);
    }

    public static class Builder<B extends Block, S extends IBlockSubtype>
    extends FeatureGroup.Builder<S, FeatureBlockGroup<B, S>> {
        private final IFeatureRegistry registry;
        private final Function<S, B> constructor;
        @Nullable
        private BiFunction<B, S, BlockItem> itemConstructor;

        public Builder(IFeatureRegistry registry, Function<S, B> constructor) {
            super(registry);
            this.registry = registry;
            this.constructor = constructor;
        }

        public Builder<B, S> itemWithType(BiFunction<B, S, BlockItem> itemConstructor) {
            this.itemConstructor = itemConstructor;
            return this;
        }

        public Builder<B, S> item(Function<B, BlockItem> itemConstructor) {
            this.itemConstructor = (block, type) -> (BlockItem)itemConstructor.apply(block);
            return this;
        }

        @Override
        public FeatureBlockGroup<B, S> create() {
            return new FeatureBlockGroup(this);
        }
    }
}

