/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.core.fluids.BlockForestryFluid;
import forestry.core.items.definitions.DrinkProperties;
import forestry.modules.features.FluidProperties;
import forestry.modules.features.IBlockFeature;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.IFluidFeature;
import forestry.modules.features.ModFeature;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class FeatureFluid
extends ModFeature
implements IFluidFeature {
    private final IBlockFeature<BlockForestryFluid, BlockItem> block;
    private final FluidProperties properties;
    private final ForgeFlowingFluid.Properties internal;
    private final RegistryObject<? extends FlowingFluid> fluidObject;
    private final RegistryObject<? extends FlowingFluid> flowingFluidObject;

    public FeatureFluid(Builder builder) {
        super(builder.moduleId, builder.identifier);
        this.block = builder.registry.block(() -> new BlockForestryFluid(this), "fluid_" + builder.identifier);
        this.properties = new FluidProperties(builder);
        RegistryObject attributes = builder.registry.getRegistry(ForgeRegistries.Keys.FLUID_TYPES).register(this.name, () -> new ForestryFluidType(this.properties, FluidType.Properties.create().density(this.properties.density).viscosity(this.properties.viscosity).temperature(this.properties.temperature)));
        DeferredRegister fluidRegistry = builder.registry.getRegistry(Registry.f_122899_);
        this.internal = new ForgeFlowingFluid.Properties((Supplier)attributes, this::fluid, this::flowing).block(this.block::block).bucket(this.properties().bucket);
        this.fluidObject = fluidRegistry.register(this.name, () -> new ForgeFlowingFluid.Source(this.internal));
        this.flowingFluidObject = fluidRegistry.register(this.name + "_flowing", () -> new ForgeFlowingFluid.Flowing(this.internal));
    }

    @Override
    public ResourceKey<? extends Registry<?>> getRegistry() {
        return Registry.f_122899_;
    }

    @Override
    public IBlockFeature<BlockForestryFluid, BlockItem> fluidBlock() {
        return this.block;
    }

    @Override
    public FlowingFluid fluid() {
        return (FlowingFluid)this.fluidObject.get();
    }

    @Override
    public FlowingFluid flowing() {
        return (FlowingFluid)this.flowingFluidObject.get();
    }

    @Override
    public FluidProperties properties() {
        return this.properties;
    }

    public static class Builder {
        private final IFeatureRegistry registry;
        private final ResourceLocation moduleId;
        final String identifier;
        int density = 1000;
        int viscosity = 1000;
        int temperature = 295;
        Color particleColor = Color.WHITE;
        int flammability = 0;
        boolean spreadsFire = false;
        @Nullable
        DrinkProperties properties = null;
        Supplier<Item> bucket = () -> Items.f_41852_;

        public Builder(IFeatureRegistry registry, ResourceLocation moduleId, String identifier) {
            this.registry = registry;
            this.moduleId = moduleId;
            this.identifier = identifier;
        }

        public Builder spreadsFire() {
            this.spreadsFire = true;
            return this;
        }

        public Builder flammability(int flammability) {
            this.flammability = flammability;
            return this;
        }

        public Builder density(int density) {
            this.density = density;
            return this;
        }

        public Builder viscosity(int viscosity) {
            this.viscosity = viscosity;
            return this;
        }

        public Builder temperature(int temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder particleColor(Color color) {
            this.particleColor = color;
            return this;
        }

        public Builder bucket(Supplier<Item> bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder drinkProperties(int healAmount, float saturationModifier, int maxItemUseDuration) {
            this.properties = new DrinkProperties(healAmount, saturationModifier, maxItemUseDuration);
            return this;
        }

        public FeatureFluid create() {
            return this.registry.register(new FeatureFluid(this));
        }
    }

    public static class ForestryFluidType
    extends FluidType {
        private final int color;
        private final ResourceLocation stillTexture;
        private final ResourceLocation flowingTexture;

        public ForestryFluidType(FluidProperties forestryProps, FluidType.Properties properties) {
            super(properties);
            this.color = forestryProps.particleColor.getRGB();
            this.stillTexture = forestryProps.resources[0];
            this.flowingTexture = forestryProps.resources[1];
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                public int getTintColor() {
                    return color;
                }
            });
        }
    }
}

