/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import com.google.common.collect.ImmutableMap;
import forestry.api.core.IFeatureSubtype;
import forestry.api.core.IItemProvider;
import forestry.modules.features.FeatureItem;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.IModFeature;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class FeatureGroup<B extends Builder<S, ? extends FeatureGroup<B, F, S>>, F extends IModFeature, S extends IFeatureSubtype> {
    protected final ImmutableMap<S, F> featureByType;

    protected FeatureGroup(B builder) {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        ((Builder)builder).subTypes.forEach(subType -> mapBuilder.put(subType, this.createFeature(builder, subType)));
        this.featureByType = mapBuilder.build();
    }

    protected abstract F createFeature(B var1, S var2);

    public boolean has(S subType) {
        return this.featureByType.containsKey(subType);
    }

    public F get(S subType) {
        return (F)((IModFeature)this.featureByType.get(subType));
    }

    public Optional<F> getProbably(S subType) {
        return Optional.ofNullable((IModFeature)this.featureByType.get(subType));
    }

    public ImmutableMap<S, F> getFeatureByType() {
        return this.featureByType;
    }

    public Collection<F> getFeatures() {
        return this.featureByType.values();
    }

    public Optional<F> findFeature(String typeName) {
        return this.featureByType.entrySet().stream().filter(e -> ((IFeatureSubtype)e.getKey()).m_7912_().equals(typeName)).findFirst().flatMap(e -> Optional.of((IModFeature)e.getValue()));
    }

    public boolean itemEqual(ItemStack stack) {
        for (IModFeature feature : this.getFeatures()) {
            FeatureItem itemFeature;
            if (!(feature instanceof FeatureItem) || !(itemFeature = (FeatureItem)feature).itemEqual(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean itemEqual(Item item) {
        for (IModFeature feature : this.getFeatures()) {
            FeatureItem itemFeature;
            if (!(feature instanceof FeatureItem) || !(itemFeature = (FeatureItem)feature).itemEqual(item)) continue;
            return true;
        }
        return false;
    }

    public ItemStack stack(S subType) {
        return this.stack(subType, 1);
    }

    public ItemStack stack(S subType, int amount) {
        IModFeature featureBlock = (IModFeature)this.featureByType.get(subType);
        if (featureBlock instanceof IItemProvider) {
            IItemProvider item = (IItemProvider)((Object)featureBlock);
            return item.stack(amount);
        }
        throw new IllegalStateException("This feature group has no item registered for the given sub type to create a stack for.");
    }

    public static abstract class Builder<S extends IFeatureSubtype, G> {
        protected final IFeatureRegistry registry;
        protected final Set<S> subTypes = new LinkedHashSet<S>();
        protected IdentifierType identifierType = IdentifierType.TYPE_ONLY;
        protected String identifier = "";

        public Builder(IFeatureRegistry registry) {
            this.registry = registry;
        }

        public Builder<S, G> identifier(String identifier) {
            return this.identifier(identifier, IdentifierType.PREFIX);
        }

        public Builder<S, G> identifier(String identifier, IdentifierType type) {
            this.identifier = identifier;
            this.identifierType = type;
            return this;
        }

        public Builder<S, G> type(S type) {
            this.subTypes.add(type);
            return this;
        }

        public Builder<S, G> types(S[] types) {
            return this.types(Arrays.asList(types));
        }

        public Builder<S, G> types(Collection<S> types) {
            this.subTypes.addAll(types);
            return this;
        }

        protected String getIdentifier(IFeatureSubtype type) {
            return (String)this.identifierType.apply(this.identifier, type.m_7912_());
        }

        public abstract G create();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum IdentifierType implements BiFunction<String, String, String>
    {
        TYPE_ONLY{

            @Override
            public String apply(String feature, String type) {
                return type;
            }
        }
        ,
        PREFIX{

            @Override
            public String apply(String feature, String type) {
                return feature + "_" + type;
            }
        }
        ,
        AFFIX{

            @Override
            public String apply(String feature, String type) {
                return type + "_" + feature;
            }
        };

    }
}

