/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.api.ForestryConstants;
import forestry.core.items.definitions.DrinkProperties;
import forestry.modules.features.FeatureFluid;
import java.awt.Color;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class FluidProperties {
    public final int density;
    public final int viscosity;
    public final int temperature;
    public final Color particleColor;
    public final int flammability;
    public final boolean spreadsFire;
    @Nullable
    public final DrinkProperties properties;
    public final ResourceLocation[] resources = new ResourceLocation[2];
    public final Supplier<Item> bucket;

    public FluidProperties(FeatureFluid.Builder builder) {
        this.density = builder.density;
        this.viscosity = builder.viscosity;
        this.temperature = builder.temperature;
        this.particleColor = builder.particleColor;
        this.flammability = builder.flammability;
        this.spreadsFire = builder.spreadsFire;
        this.properties = builder.properties;
        this.resources[0] = ForestryConstants.forestry("block/liquid/" + builder.identifier + "_still");
        this.resources[1] = ForestryConstants.forestry("block/liquid/" + builder.identifier + "_flow");
        if (!this.resourceExists(this.resources[1])) {
            this.resources[1] = this.resources[0];
        }
        this.bucket = builder.bucket;
    }

    public boolean resourceExists(ResourceLocation location) {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER || DatagenModLoader.isRunningDataGen()) {
            return true;
        }
        return Minecraft.m_91087_().m_91098_().m_213713_(location).isPresent();
    }
}

