/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedListMultimap;
import forestry.api.core.IBlockSubtype;
import forestry.api.core.IFeatureSubtype;
import forestry.api.core.IItemSubtype;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.modules.ModuleUtil;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureBlockGroup;
import forestry.modules.features.FeatureBlockTable;
import forestry.modules.features.FeatureEntityType;
import forestry.modules.features.FeatureFluid;
import forestry.modules.features.FeatureItem;
import forestry.modules.features.FeatureItemGroup;
import forestry.modules.features.FeatureItemTable;
import forestry.modules.features.FeatureMenuType;
import forestry.modules.features.FeatureRecipeType;
import forestry.modules.features.FeatureTileType;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.IModFeature;
import forestry.storage.ModuleStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegisterEvent;

public class ModFeatureRegistry {
    private static final LinkedHashMap<String, ModFeatureRegistry> MOD_REGISTRY = new LinkedHashMap();
    private final HashMap<ResourceLocation, ModuleFeatureRegistry> modules = new LinkedHashMap<ResourceLocation, ModuleFeatureRegistry>();
    private final IEventBus modBus;

    private ModFeatureRegistry(String modId) {
        this.modBus = ModuleUtil.getModBus(modId);
        this.modBus.addListener(EventPriority.LOWEST, this::postRegistry);
    }

    public void register(IModFeature feature) {
        this.getRegistry(feature.getModuleId()).register(feature);
    }

    public void postRegistry(RegisterEvent event) {
        for (ModuleFeatureRegistry features : this.modules.values()) {
            features.postRegistry(event);
        }
    }

    public static IFeatureRegistry get(ResourceLocation moduleId) {
        return MOD_REGISTRY.computeIfAbsent(moduleId.m_135827_(), ModFeatureRegistry::new).getRegistry(moduleId);
    }

    public static Map<String, ModFeatureRegistry> getRegistries() {
        return MOD_REGISTRY;
    }

    public IFeatureRegistry getRegistry(ResourceLocation moduleId) {
        return this.modules.computeIfAbsent(moduleId, key -> new ModuleFeatureRegistry((ResourceLocation)key, this.modBus));
    }

    public Map<ResourceLocation, IFeatureRegistry> getModules() {
        return Collections.unmodifiableMap(this.modules);
    }

    private static class ModuleFeatureRegistry
    implements IFeatureRegistry {
        private final ArrayList<IModFeature> features = new ArrayList();
        private final ArrayListMultimap<ResourceKey<? extends Registry<?>>, IModFeature> featureByRegistry = ArrayListMultimap.create();
        private final HashMap<ResourceKey, DeferredRegister> registries = new HashMap();
        private final LinkedListMultimap<ResourceKey<? extends Registry<?>>, Consumer<RegisterEvent>> registryListeners = LinkedListMultimap.create();
        private final ResourceLocation moduleId;
        private final IEventBus modBus;

        public ModuleFeatureRegistry(ResourceLocation moduleId, IEventBus modBus) {
            this.moduleId = moduleId;
            this.modBus = modBus;
        }

        @Override
        public <V> DeferredRegister<V> getRegistry(ResourceKey<? extends Registry<V>> registryKey) {
            String modId = this.moduleId.m_135827_();
            return this.registries.computeIfAbsent(registryKey, key -> {
                DeferredRegister registry = DeferredRegister.create((ResourceKey)key, (String)modId);
                registry.register(this.modBus);
                return registry;
            });
        }

        @Override
        @Nullable
        public <V> DeferredRegister<V> getRegistryNullable(ResourceKey<? extends Registry<V>> registry) {
            return this.registries.get(registry);
        }

        @Override
        public <B extends Block, I extends BlockItem> FeatureBlock<B, I> block(Supplier<B> constructor, String name) {
            return this.block(constructor, null, name);
        }

        @Override
        public <B extends Block, I extends BlockItem> FeatureBlock<B, I> block(Supplier<B> constructor, @Nullable Function<B, I> itemConstructor, String name) {
            return this.register(new FeatureBlock<B, I>(this, this.moduleId, name, constructor, itemConstructor));
        }

        @Override
        public <B extends Block, S extends IBlockSubtype> FeatureBlockGroup.Builder<B, S> blockGroup(Function<S, B> constructor, Class<? extends S> typeClass) {
            return new FeatureBlockGroup.Builder<B, S>(this, constructor);
        }

        @Override
        public <B extends Block, S extends IBlockSubtype> FeatureBlockGroup.Builder<B, S> blockGroup(Function<S, B> constructor, Collection<S> types) {
            return (FeatureBlockGroup.Builder)new FeatureBlockGroup.Builder<B, S>(this, constructor).types(types);
        }

        @Override
        public <B extends Block, S extends IBlockSubtype> FeatureBlockGroup.Builder<B, S> blockGroup(Function<S, B> constructor, S[] types) {
            return (FeatureBlockGroup.Builder)new FeatureBlockGroup.Builder<B, S>(this, constructor).types((IFeatureSubtype[])types);
        }

        @Override
        public <I extends Item> FeatureItem<I> item(Supplier<I> constructor, String name) {
            return this.register(new FeatureItem<I>(this, this.moduleId, name, constructor));
        }

        @Override
        public FeatureItem<Item> backpack(IBackpackDefinition definition, EnumBackpackType type, String identifier) {
            return this.item(() -> ModuleStorage.BACKPACK_INTERFACE.createBackpack(definition, type), identifier);
        }

        @Override
        public FeatureItem<Item> naturalistBackpack(IBackpackDefinition definition, ResourceLocation speciesTypeId, CreativeModeTab tab, String identifier) {
            return this.item(() -> ModuleStorage.BACKPACK_INTERFACE.createNaturalistBackpack(definition, speciesTypeId, tab), identifier);
        }

        @Override
        public <I extends Item, S extends IItemSubtype> FeatureItemGroup<I, S> itemGroup(Function<S, I> constructor, String identifier, S[] subTypes) {
            return (FeatureItemGroup)this.itemGroup(constructor, (IItemSubtype[])subTypes).identifier(identifier).create();
        }

        @Override
        public <I extends Item, S extends IItemSubtype> FeatureItemGroup.Builder<I, S> itemGroup(Function<S, I> constructor, S[] subTypes) {
            return (FeatureItemGroup.Builder)new FeatureItemGroup.Builder<I, S>(this, constructor).types((IFeatureSubtype[])subTypes);
        }

        @Override
        public <I extends Item, R extends IItemSubtype, C extends IItemSubtype> FeatureItemTable<I, R, C> itemTable(BiFunction<R, C, I> constructor, R[] rowTypes, C[] columnTypes, String identifier) {
            return (FeatureItemTable)this.itemTable(constructor, (IItemSubtype[])rowTypes, (IItemSubtype[])columnTypes).identifier(identifier).create();
        }

        @Override
        public <I extends Item, R extends IItemSubtype, C extends IItemSubtype> FeatureItemTable.Builder<I, R, C> itemTable(BiFunction<R, C, I> constructor, R[] rowTypes, C[] columnTypes) {
            return (FeatureItemTable.Builder)new FeatureItemTable.Builder<I, R, C>(this, constructor).rowTypes((IFeatureSubtype[])rowTypes).columnTypes((IFeatureSubtype[])columnTypes);
        }

        @Override
        public <B extends Block, R extends IBlockSubtype, C extends IBlockSubtype> FeatureBlockTable.Builder<B, R, C> blockTable(BiFunction<R, C, B> constructor, R[] rowTypes, C[] columnTypes) {
            return (FeatureBlockTable.Builder)new FeatureBlockTable.Builder<B, R, C>(this, constructor).rowTypes((IFeatureSubtype[])rowTypes).columnTypes((IFeatureSubtype[])columnTypes);
        }

        @Override
        public FeatureFluid.Builder fluid(String identifier) {
            return new FeatureFluid.Builder(this, this.moduleId, identifier);
        }

        @Override
        public <R extends Recipe<?>> FeatureRecipeType<R> recipeType(String name, Supplier<RecipeSerializer<? extends R>> serializer) {
            return new FeatureRecipeType<R>(this, this.moduleId, name, serializer);
        }

        @Override
        public void addRegistryListener(ResourceKey<? extends Registry<?>> type, Consumer<RegisterEvent> listener) {
            this.registryListeners.put(type, listener);
        }

        @Override
        public <F extends IModFeature> F register(F feature) {
            this.features.add(feature);
            this.featureByRegistry.put(feature.getRegistry(), feature);
            return feature;
        }

        @Override
        public <T extends BlockEntity> FeatureTileType<T> tile(BlockEntityType.BlockEntitySupplier<T> constructor, String identifier, Supplier<Collection<? extends Block>> validBlocks) {
            return this.register(new FeatureTileType<T>(this, this.moduleId, identifier, constructor, validBlocks));
        }

        @Override
        public <C extends AbstractContainerMenu> FeatureMenuType<C> menuType(IContainerFactory<C> factory, String identifier) {
            return this.register(new FeatureMenuType<C>(this, this.moduleId, identifier, factory));
        }

        @Override
        public <E extends Entity> FeatureEntityType<E> entity(EntityType.EntityFactory<E> factory, MobCategory classification, String identifier) {
            return this.entity(factory, classification, identifier, builder -> builder);
        }

        @Override
        public <E extends Entity> FeatureEntityType<E> entity(EntityType.EntityFactory<E> factory, MobCategory classification, String identifier, UnaryOperator<EntityType.Builder<E>> consumer) {
            return this.entity(factory, classification, identifier, consumer, LivingEntity::m_21183_);
        }

        @Override
        public <E extends Entity> FeatureEntityType<E> entity(EntityType.EntityFactory<E> factory, MobCategory classification, String identifier, UnaryOperator<EntityType.Builder<E>> consumer, Supplier<AttributeSupplier.Builder> attributes) {
            return this.register(new FeatureEntityType(this, this.moduleId, identifier, consumer, factory, classification, attributes));
        }

        @Override
        public Collection<IModFeature> getFeatures() {
            return this.features;
        }

        @Override
        public Collection<IModFeature> getFeatures(ResourceKey<? extends Registry<?>> type) {
            return this.featureByRegistry.get(type);
        }

        public void postRegistry(RegisterEvent event) {
            for (Consumer listener : this.registryListeners.get((Object)event.getRegistryKey())) {
                listener.accept(event);
            }
        }
    }
}

