/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugin;

import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.IFruit;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.core.IProduct;
import forestry.api.farming.ForestryFarmTypes;
import forestry.api.genetics.alleles.ForestryAlleles;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.api.plugin.IFarmTypeBuilder;
import forestry.api.plugin.IFarmingRegistration;
import forestry.core.features.CoreBlocks;
import forestry.core.features.CoreItems;
import forestry.core.items.ItemFruit;
import forestry.core.utils.SpeciesUtil;
import forestry.farming.logic.FarmLogicArboreal;
import forestry.farming.logic.FarmLogicCocoa;
import forestry.farming.logic.FarmLogicCrops;
import forestry.farming.logic.FarmLogicEnder;
import forestry.farming.logic.FarmLogicGourd;
import forestry.farming.logic.FarmLogicInfernal;
import forestry.farming.logic.FarmLogicMushroom;
import forestry.farming.logic.FarmLogicOrchard;
import forestry.farming.logic.FarmLogicPeat;
import forestry.farming.logic.FarmLogicReeds;
import forestry.farming.logic.FarmLogicSucculent;
import forestry.farming.logic.farmables.FarmableAgingCrop;
import forestry.farming.logic.farmables.FarmableChorus;
import forestry.farming.logic.farmables.FarmableGE;
import forestry.farming.logic.farmables.FarmableGourd;
import forestry.farming.logic.farmables.FarmableMangroveTree;
import forestry.farming.logic.farmables.FarmableSapling;
import forestry.farming.logic.farmables.FarmableStacked;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class DefaultFarms {
    public static void registerFarmTypes(IFarmingRegistration farming) {
        IFarmTypeBuilder arboreal = farming.createFarmType(ForestryFarmTypes.ARBOREAL, FarmLogicArboreal::new, new ItemStack((ItemLike)Blocks.f_50746_)).setFertilizerConsumption(10).setWaterConsumption(hydrationModifier -> (int)(10.0f * hydrationModifier)).addSoil(new ItemStack((ItemLike)Blocks.f_50493_), CoreBlocks.HUMUS.defaultState()).addSoil(CoreBlocks.HUMUS.stack(), CoreBlocks.HUMUS.defaultState());
        DefaultFarms.addTreeFarmables(arboreal);
        IFarmTypeBuilder crops = farming.createFarmType(ForestryFarmTypes.CROPS, FarmLogicCrops::new, new ItemStack((ItemLike)Items.f_42405_)).setWaterConsumption(hydrationModifier -> (int)(20.0f * hydrationModifier)).setFertilizerConsumption(5).addSoil(new ItemStack((ItemLike)Blocks.f_50493_), Blocks.f_50093_.m_49966_());
        DefaultFarms.addCropFarmables(crops);
        IFarmTypeBuilder gourd = farming.createFarmType(ForestryFarmTypes.GOURD, FarmLogicGourd::new, new ItemStack((ItemLike)Items.f_42028_)).setFertilizerConsumption(10).setWaterConsumption(hydrationModifier -> (int)(40.0f * hydrationModifier));
        DefaultFarms.addGourdFarmables(gourd);
        IFarmTypeBuilder shroom = farming.createFarmType(ForestryFarmTypes.SHROOM, FarmLogicMushroom::new, new ItemStack((ItemLike)Blocks.f_50073_)).setFertilizerConsumption(20).setWaterConsumption(hydrationModifier -> (int)(80.0f * hydrationModifier)).addSoil(Blocks.f_50195_).addSoil(Blocks.f_50599_);
        IFarmTypeBuilder infernal = farming.createFarmType(ForestryFarmTypes.INFERNAL, FarmLogicInfernal::new, new ItemStack((ItemLike)Items.f_42588_)).setFertilizerConsumption(20).setWaterConsumption(0).addSoil(Blocks.f_50135_);
        infernal.addFarmable(new FarmableAgingCrop(Items.f_42588_, Blocks.f_50200_, (Property<Integer>)NetherWartBlock.f_54967_, 3));
        IFarmTypeBuilder poales = farming.createFarmType(ForestryFarmTypes.POALES, FarmLogicReeds::new, new ItemStack((ItemLike)Items.f_41909_)).setFertilizerConsumption(10).setWaterConsumption(hydrationModifier -> (int)(20.0f * hydrationModifier)).addSoil(Blocks.f_49992_).addSoil(Blocks.f_50493_);
        poales.addFarmable(new FarmableStacked(new ItemStack((ItemLike)Items.f_41909_), Blocks.f_50130_, 3));
        IFarmTypeBuilder cactus = farming.createFarmType(ForestryFarmTypes.SUCCULENTES, FarmLogicSucculent::new, new ItemStack((ItemLike)Items.f_42496_)).setFertilizerConsumption(10).setWaterConsumption(1).addSoil(Blocks.f_49992_);
        cactus.addFarmable(new FarmableStacked(new ItemStack((ItemLike)Blocks.f_50128_), Blocks.f_50128_, 3));
        IFarmTypeBuilder ender = farming.createFarmType(ForestryFarmTypes.ENDER, FarmLogicEnder::new, new ItemStack((ItemLike)Items.f_42545_)).setFertilizerConsumption(20).setWaterConsumption(0).addSoil(Blocks.f_50259_);
        ender.addFarmable(FarmableChorus.INSTANCE);
        IFarmTypeBuilder peat = farming.createFarmType(ForestryFarmTypes.PEAT, FarmLogicPeat::new, CoreItems.PEAT.stack()).setWaterConsumption(hydrationModifier -> (int)(20.0f * hydrationModifier)).setFertilizerConsumption(2).addSoil(CoreBlocks.BOG_EARTH.stack(), CoreBlocks.BOG_EARTH.defaultState()).addProducts(List.of(CoreItems.PEAT.stack(), new ItemStack((ItemLike)Blocks.f_50493_)));
        IFarmTypeBuilder orchard = farming.createFarmType(ForestryFarmTypes.ORCHARD, FarmLogicOrchard::new, CoreItems.FRUITS.stack(ItemFruit.EnumFruit.CHERRY)).setFertilizerConsumption(10).setWaterConsumption(hydrationModifier -> (int)(40.0f * hydrationModifier));
        for (ITreeSpecies species : ((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).getAllSpecies()) {
            IValueAllele fruitAllele = (IValueAllele)((Object)species.getDefaultGenome().getActiveAllele(TreeChromosomes.FRUIT));
            if (fruitAllele == ForestryAlleles.FRUIT_NONE) continue;
            IFruit fruit = (IFruit)fruitAllele.value();
            orchard.addGermling(species.createStack(TreeLifeStage.SAPLING)).addProducts(fruit.getProducts().stream().map(IProduct::createStack).toList()).addProducts(fruit.getSpecialty().stream().map(IProduct::createStack).toList());
        }
        IFarmTypeBuilder cocoa = farming.createFarmType(ForestryFarmTypes.COCOA, FarmLogicCocoa::new, new ItemStack((ItemLike)Items.f_42533_)).setFertilizerConsumption(120).setWaterConsumption(hydrationModifier -> (int)(20.0f * hydrationModifier)).addGermling(new ItemStack((ItemLike)Items.f_42533_)).addProduct(new ItemStack((ItemLike)Items.f_42533_));
    }

    private static void addGourdFarmables(IFarmTypeBuilder gourd) {
        gourd.addFarmable(new FarmableGourd(new ItemStack((ItemLike)Items.f_42577_), Blocks.f_50189_, Blocks.f_50133_));
        gourd.addFarmable(new FarmableGourd(new ItemStack((ItemLike)Items.f_42578_), Blocks.f_50190_, Blocks.f_50186_));
    }

    private static void addTreeFarmables(IFarmTypeBuilder arboreal) {
        arboreal.addWindfallFarmable(Items.f_42799_, FarmableSapling::new, builder -> builder.addWindfall(List.of(Items.f_42410_, Items.f_42398_)));
        arboreal.addWindfallFarmable(Items.f_42801_, FarmableSapling::new, builder -> builder.addWindfall(Items.f_42398_));
        arboreal.addWindfallFarmable(Items.f_42800_, FarmableSapling::new, builder -> builder.addWindfall(Items.f_42398_));
        arboreal.addWindfallFarmable(Items.f_41826_, FarmableSapling::new, builder -> builder.addWindfall(List.of(Items.f_42398_, Items.f_42533_)));
        arboreal.addWindfallFarmable(Items.f_41828_, FarmableSapling::new, builder -> builder.addWindfall(Items.f_42398_));
        arboreal.addWindfallFarmable(Items.f_41827_, FarmableSapling::new, builder -> builder.addWindfall(Items.f_42398_));
        arboreal.addWindfallFarmable(Items.f_220175_, FarmableMangroveTree::new, builder -> builder.addWindfall(List.of(Items.f_42398_, Items.f_151015_)));
        arboreal.addFarmable(new FarmableGE());
    }

    private static void addCropFarmables(IFarmTypeBuilder crops) {
        crops.addFarmable(new FarmableAgingCrop(Items.f_42404_, Blocks.f_50092_, new ItemStack((ItemLike)Items.f_42405_), (Property<Integer>)CropBlock.f_52244_, 7, (Integer)0));
        crops.addFarmable(new FarmableAgingCrop(Items.f_42620_, Blocks.f_50250_, new ItemStack((ItemLike)Items.f_42620_), (Property<Integer>)CropBlock.f_52244_, 7, (Integer)0));
        crops.addFarmable(new FarmableAgingCrop(Items.f_42619_, Blocks.f_50249_, new ItemStack((ItemLike)Items.f_42619_), (Property<Integer>)CropBlock.f_52244_, 7, (Integer)0));
        crops.addFarmable(new FarmableAgingCrop(Items.f_42733_, Blocks.f_50444_, new ItemStack((ItemLike)Items.f_42732_), (Property<Integer>)BeetrootBlock.f_49657_, 3, (Integer)0));
    }
}

