/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugin;

import forestry.api.arboriculture.ForestryTreeSpecies;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.api.genetics.alleles.ForestryAlleles;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.api.plugin.IArboricultureRegistration;
import forestry.api.plugin.ITreeSpeciesBuilder;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.VanillaWoodType;
import forestry.arboriculture.blocks.BlockDefaultLeaves;
import forestry.arboriculture.blocks.BlockDefaultLeavesFruit;
import forestry.arboriculture.blocks.ForestryLeafType;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.worldgen.FeatureAcacia;
import forestry.arboriculture.worldgen.FeatureAcaciaVanilla;
import forestry.arboriculture.worldgen.FeatureBalsa;
import forestry.arboriculture.worldgen.FeatureBaobab;
import forestry.arboriculture.worldgen.FeatureBirch;
import forestry.arboriculture.worldgen.FeatureCherry;
import forestry.arboriculture.worldgen.FeatureChestnut;
import forestry.arboriculture.worldgen.FeatureCocobolo;
import forestry.arboriculture.worldgen.FeatureDarkOak;
import forestry.arboriculture.worldgen.FeatureDate;
import forestry.arboriculture.worldgen.FeatureEbony;
import forestry.arboriculture.worldgen.FeatureGiganteum;
import forestry.arboriculture.worldgen.FeatureGreenheart;
import forestry.arboriculture.worldgen.FeatureIpe;
import forestry.arboriculture.worldgen.FeatureJungle;
import forestry.arboriculture.worldgen.FeatureKapok;
import forestry.arboriculture.worldgen.FeatureLarch;
import forestry.arboriculture.worldgen.FeatureLemon;
import forestry.arboriculture.worldgen.FeatureMahoe;
import forestry.arboriculture.worldgen.FeatureMahogany;
import forestry.arboriculture.worldgen.FeatureMaple;
import forestry.arboriculture.worldgen.FeatureOak;
import forestry.arboriculture.worldgen.FeaturePadauk;
import forestry.arboriculture.worldgen.FeaturePapaya;
import forestry.arboriculture.worldgen.FeaturePine;
import forestry.arboriculture.worldgen.FeaturePlum;
import forestry.arboriculture.worldgen.FeaturePoplar;
import forestry.arboriculture.worldgen.FeatureSequoia;
import forestry.arboriculture.worldgen.FeatureSilverLime;
import forestry.arboriculture.worldgen.FeatureSpruce;
import forestry.arboriculture.worldgen.FeatureTeak;
import forestry.arboriculture.worldgen.FeatureWalnut;
import forestry.arboriculture.worldgen.FeatureWenge;
import forestry.arboriculture.worldgen.FeatureWillow;
import forestry.arboriculture.worldgen.FeatureZebrawood;
import forestry.modules.features.FeatureBlock;
import java.awt.Color;
import java.util.Collection;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class DefaultTreeSpecies {
    public static void register(IArboricultureRegistration arboriculture) {
        arboriculture.registerSpecies(ForestryTreeSpecies.OAK, "quercus", "robur", false, new Color(4764952), VanillaWoodType.OAK).setTreeFeature(FeatureOak::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.OAK)).addVanillaStates((Collection<BlockState>)Blocks.f_50050_.m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.OAK)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.OAK)).block()).m_49965_().m_61056_()).addVanillaSapling(Items.f_42799_).setGenome(genome -> {
            genome.set(TreeChromosomes.FRUIT, ForestryAlleles.FRUIT_APPLE);
            genome.set(TreeChromosomes.SAPLINGS, ForestryAlleles.SAPLINGS_AVERAGE);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_FASTER);
        });
        ((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.DARK_OAK, "quercus", "velutina", false, new Color(4764952), VanillaWoodType.DARK_OAK).setTreeFeature(FeatureDarkOak::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.DARK_OAK)).addVanillaStates((Collection<BlockState>)Blocks.f_50055_.m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.DARK_OAK)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.DARK_OAK)).block()).m_49965_().m_61056_()).addVanillaSapling(Items.f_41828_).setGenome(genome -> {
            genome.set(TreeChromosomes.SAPLINGS, ForestryAlleles.SAPLINGS_AVERAGE);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_FASTER);
            genome.set(TreeChromosomes.GIRTH, ForestryAlleles.GIRTH_2);
        })).setAuthority("Binnie");
        arboriculture.registerSpecies(ForestryTreeSpecies.BIRCH, "betula", "pendula", false, new Color(8431445), VanillaWoodType.BIRCH).setTreeFeature(FeatureBirch::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.BIRCH)).addVanillaStates((Collection<BlockState>)Blocks.f_50052_.m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.BIRCH)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.BIRCH)).block()).m_49965_().m_61056_()).addVanillaSapling(Items.f_42801_).setGenome(genome -> {
            genome.set(TreeChromosomes.SAPLINGS, ForestryAlleles.SAPLINGS_AVERAGE);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_FASTER);
        });
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.LIME, "tilia", "tomentosa", true, new Color(6201607), ForestryWoodType.LIME).setTreeFeature(FeatureSilverLime::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.LIME)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.LIME)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.LIME)).block()).m_49965_().m_61056_()).setGenome(genome -> {
            genome.set(TreeChromosomes.SAPLINGS, ForestryAlleles.SAPLINGS_LOW);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOWER);
            genome.set(TreeChromosomes.YIELD, ForestryAlleles.YIELD_LOWER);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.BIRCH, ForestryTreeSpecies.OAK, 15))).setRarity(0.005f);
        ((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.WALNUT, "juglans", "regia", true, new Color(7965781), ForestryWoodType.WALNUT).setTreeFeature(FeatureWalnut::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.WALNUT)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.WALNUT)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.WALNUT)).block()).m_49965_().m_61056_()).setGenome(genome -> {
            genome.set(TreeChromosomes.FRUIT, ForestryAlleles.FRUIT_WALNUT);
            genome.set(TreeChromosomes.SAPLINGS, ForestryAlleles.SAPLINGS_LOWER);
            genome.set(TreeChromosomes.YIELD, ForestryAlleles.YIELD_AVERAGE);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOWER);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_AVERAGE);
            genome.set(TreeChromosomes.GIRTH, ForestryAlleles.GIRTH_2);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.LIME, ForestryTreeSpecies.CHERRY, 10));
        ((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.CHESTNUT, "castanea", "sativa", true, new Color(6201607), ForestryWoodType.CHESTNUT).setTreeFeature(FeatureChestnut::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.CHESTNUT)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.CHESTNUT)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.CHESTNUT)).block()).m_49965_().m_61056_()).setGenome(genome -> {
            genome.set(TreeChromosomes.FRUIT, ForestryAlleles.FRUIT_CHESTNUT);
            genome.set(TreeChromosomes.YIELD, ForestryAlleles.YIELD_AVERAGE);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOWER);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_LARGE);
            genome.set(TreeChromosomes.GIRTH, ForestryAlleles.GIRTH_2);
        })).addMutations(mutations -> {
            mutations.add(ForestryTreeSpecies.WALNUT, ForestryTreeSpecies.LIME, 10);
            mutations.add(ForestryTreeSpecies.WALNUT, ForestryTreeSpecies.CHERRY, 10);
        });
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.CHERRY, "prunus", "serrulata", true, new Color(15110618), ForestryWoodType.CHERRY).setTreeFeature(FeatureCherry::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.CHERRY)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.CHERRY)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.CHERRY)).block()).m_49965_().m_61056_()).setGenome(genome -> {
            genome.set(TreeChromosomes.FRUIT, ForestryAlleles.FRUIT_CHERRY);
            genome.set(TreeChromosomes.SAPLINGS, ForestryAlleles.SAPLINGS_LOW);
            genome.set(TreeChromosomes.YIELD, ForestryAlleles.YIELD_AVERAGE);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOW);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_SMALLER);
        })).addMutations(mutations -> {
            mutations.add(ForestryTreeSpecies.LIME, ForestryTreeSpecies.OAK, 10);
            mutations.add(ForestryTreeSpecies.LIME, ForestryTreeSpecies.BIRCH, 10);
        })).setRarity(0.0015f);
        ((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.LEMON, "citrus", "limon", true, new Color(8957780), ForestryWoodType.CITRUS).setTreeFeature(FeatureLemon::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.LEMON)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.LEMON)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.LEMON)).block()).m_49965_().m_61056_()).setGenome(genome -> {
            genome.set(TreeChromosomes.FRUIT, ForestryAlleles.FRUIT_LEMON);
            genome.set(TreeChromosomes.YIELD, ForestryAlleles.YIELD_LOWER);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_AVERAGE);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_SMALLEST);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.LIME, ForestryTreeSpecies.CHERRY, 5));
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.PLUM, "prunus", "domestica", true, new Color(5804614), ForestryWoodType.PLUM).setTreeFeature(FeaturePlum::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.PLUM)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.PLUM)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.PLUM)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).setGenome(genome -> {
            genome.set(TreeChromosomes.FRUIT, ForestryAlleles.FRUIT_PLUM);
            genome.set(TreeChromosomes.YIELD, ForestryAlleles.YIELD_HIGH);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_AVERAGE);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_SMALLEST);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.LEMON, ForestryTreeSpecies.CHERRY, 5))).setRarity(0.005f);
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.MAPLE, "acer", "saccharum", true, new Color(13956133), ForestryWoodType.MAPLE).setTreeFeature(FeatureMaple::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.MAPLE)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.MAPLE)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.MAPLE)).block()).m_49965_().m_61056_()).setGenome(genome -> {
            genome.set(TreeChromosomes.SAPLINGS, ForestryAlleles.SAPLINGS_LOW);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOWER);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_AVERAGE);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.SPRUCE, ForestryTreeSpecies.LARCH, 5))).setRarity(0.0025f);
        arboriculture.registerSpecies(ForestryTreeSpecies.SPRUCE, "picea", "abies", false, new Color(0x619961), VanillaWoodType.SPRUCE).setTreeFeature(FeatureSpruce::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.SPRUCE)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.SPRUCE)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.SPRUCE)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)Blocks.f_50051_.m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.SPRUCE)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.SPRUCE)).block()).m_49965_().m_61056_()).addVanillaSapling(Items.f_42800_).setGenome(genome -> {
            genome.set(TreeChromosomes.SAPLINGS, ForestryAlleles.SAPLINGS_AVERAGE);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_AVERAGE);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_FASTER);
        });
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.LARCH, "larix", "decidua", true, new Color(6918032), ForestryWoodType.LARCH).setTreeFeature(FeatureLarch::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.LARCH)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.LARCH)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.LARCH)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.COLD)).setGenome(genome -> {
            genome.set(TreeChromosomes.SAPLINGS, ForestryAlleles.SAPLINGS_LOW);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOWER);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_AVERAGE);
        })).addMutations(mutations -> {
            mutations.add(ForestryTreeSpecies.SPRUCE, ForestryTreeSpecies.BIRCH, 10);
            mutations.add(ForestryTreeSpecies.SPRUCE, ForestryTreeSpecies.OAK, 10);
        })).setRarity(0.0025f);
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.PINE, "pinus", "sabiniana", true, new Color(0xFEFF8F), ForestryWoodType.PINE).setTreeFeature(FeaturePine::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.PINE)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.PINE)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.PINE)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.COLD)).setGenome(genome -> {
            genome.set(TreeChromosomes.SAPLINGS, ForestryAlleles.SAPLINGS_LOW);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOWER);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_AVERAGE);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.SPRUCE, ForestryTreeSpecies.LARCH, 10))).setRarity(0.0025f);
        ((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.SEQUOIA, "sequoia", "sempervirens", false, new Color(4296305), ForestryWoodType.SEQUOIA).setTreeFeature(FeatureSequoia::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.SEQUOIA)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.SEQUOIA)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.SEQUOIA)).block()).m_49965_().m_61056_()).setGenome(genome -> {
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_LARGEST);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOWER);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_SLOWER);
            genome.set(TreeChromosomes.GIRTH, ForestryAlleles.GIRTH_3);
            genome.set(TreeChromosomes.FIREPROOF, true);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.LARCH, ForestryTreeSpecies.PINE, 5));
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.GIANT_SEQUOIA, "sequoiadendron", "giganteum", false, new Color(7570484), ForestryWoodType.GIGANTEUM).setTreeFeature(FeatureGiganteum::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.GIANT_SEQUOIA)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.GIANT_SEQUOIA)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.GIANT_SEQUOIA)).block()).m_49965_().m_61056_()).setGenome(genome -> {
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_GIGANTIC);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOWEST);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_SLOWEST);
            genome.set(TreeChromosomes.GIRTH, ForestryAlleles.GIRTH_4);
            genome.set(TreeChromosomes.FIREPROOF, true);
        })).setComplexity(10)).addMutations(mutations -> mutations.add(ForestryTreeSpecies.SEQUOIA, ForestryTreeSpecies.BAOBAB, 0.01f));
        arboriculture.registerSpecies(ForestryTreeSpecies.JUNGLE, "caldapis", "tectona", false, new Color(4764952), VanillaWoodType.JUNGLE).setTreeFeature(FeatureJungle::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.JUNGLE)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.JUNGLE)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.JUNGLE)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)Blocks.f_50053_.m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.JUNGLE)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.JUNGLE)).block()).m_49965_().m_61056_()).addVanillaSapling(Items.f_41826_).setGenome(genome -> {
            genome.set(TreeChromosomes.FRUIT, ForestryAlleles.FRUIT_COCOA);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_LARGER);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_FAST);
        });
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.TEAK, "tectona", "grandis", true, new Color(0xFEFF8F), ForestryWoodType.TEAK).setTreeFeature(FeatureTeak::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.TEAK)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.TEAK)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.TEAK)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).setGenome(genome -> genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOWER))).addMutations(mutations -> mutations.add(ForestryTreeSpecies.DARK_OAK, ForestryTreeSpecies.JUNGLE, 10))).setRarity(0.0025f);
        ((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.IPE, "tabebuia", "serratifolia", true, new Color(16634375), ForestryWoodType.IPE).setTreeFeature(FeatureIpe::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.IPE)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.IPE)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.IPE)).block()).m_49965_().m_61056_()).setGenome(genome -> {
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOWER);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_LARGE);
            genome.set(TreeChromosomes.GIRTH, ForestryAlleles.GIRTH_2);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.TEAK, ForestryTreeSpecies.DARK_OAK, 10));
        ((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.KAPOK, "ceiba", "pentandra", true, new Color(9017467), ForestryWoodType.KAPOK).setTreeFeature(FeatureKapok::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.KAPOK)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.KAPOK)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.KAPOK)).block()).m_49965_().m_61056_()).setGenome(genome -> {
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_LARGE);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOW);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_SLOW);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.JUNGLE, ForestryTreeSpecies.TEAK, 10));
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.EBONY, "diospyros", "pentamera", true, new Color(10670666), ForestryWoodType.EBONY).setTreeFeature(FeatureEbony::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.EBONY)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.EBONY)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.EBONY)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).setGenome(genome -> {
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_AVERAGE);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOW);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_SLOWER);
            genome.set(TreeChromosomes.GIRTH, ForestryAlleles.GIRTH_3);
        })).setRarity(5.0E-4f);
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.ZEBRAWOOD, "astronium", "graveolens", false, new Color(10670666), ForestryWoodType.ZEBRAWOOD).setTreeFeature(FeatureZebrawood::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.ZEBRAWOOD)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.ZEBRAWOOD)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.ZEBRAWOOD)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).setGenome(genome -> {
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_LARGE);
            genome.set(TreeChromosomes.GIRTH, ForestryAlleles.GIRTH_2);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.EBONY, ForestryTreeSpecies.POPLAR, 5))).setRarity(5.0E-4f);
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.MAHOGANY, "mahogany", "gibbosa", true, new Color(9089364), ForestryWoodType.MAHOGANY).setTreeFeature(FeatureMahogany::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.MAHOGANY)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.MAHOGANY)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.MAHOGANY)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).setGenome(genome -> {
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_LARGE);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOW);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_SLOW);
            genome.set(TreeChromosomes.GIRTH, ForestryAlleles.GIRTH_2);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.KAPOK, ForestryTreeSpecies.EBONY, 10))).setRarity(5.0E-4f);
        arboriculture.registerSpecies(ForestryTreeSpecies.ACACIA_VANILLA, "acacia", "aneura", true, new Color(0x616101), VanillaWoodType.ACACIA).setTreeFeature(FeatureAcaciaVanilla::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.ACACIA_VANILLA)).addVanillaStates((Collection<BlockState>)Blocks.f_50054_.m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.ACACIA_VANILLA)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.ACACIA_VANILLA)).block()).m_49965_().m_61056_()).addVanillaSapling(Items.f_41827_).setAuthority("Binnie");
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.DESERT_ACACIA, "acacia", "erioloba", true, new Color(7638044), ForestryWoodType.ACACIA_DESERT).setTreeFeature(FeatureAcacia::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.DESERT_ACACIA)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.DESERT_ACACIA)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.DESERT_ACACIA)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.ARID)).addMutations(mutations -> mutations.add(ForestryTreeSpecies.TEAK, ForestryTreeSpecies.BALSA, 10))).setRarity(0.005f);
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.PADAUK, "pterocarpus", "soyauxii", true, new Color(13688716), ForestryWoodType.PADAUK).setTreeFeature(FeaturePadauk::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.PADAUK)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.PADAUK)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.PADAUK)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setGenome(genome -> {
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOWER);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_LARGE);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.ACACIA_VANILLA, ForestryTreeSpecies.JUNGLE, 10))).setRarity(0.005f);
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.BALSA, "ochroma", "pyramidale", true, new Color(5876736), ForestryWoodType.BALSA).setTreeFeature(FeatureBalsa::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.BALSA)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.BALSA)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.BALSA)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).setGenome(genome -> {
            genome.set(TreeChromosomes.SAPLINGS, ForestryAlleles.SAPLINGS_HIGH);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOWER);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_LARGE);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.TEAK, ForestryTreeSpecies.ACACIA_VANILLA, 10))).setRarity(5.0E-4f);
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.COCOBOLO, "dalbergia", "retusa", false, new Color(6988154), ForestryWoodType.COCOBOLO).setTreeFeature(FeatureCocobolo::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.COCOBOLO)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.COCOBOLO)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.COCOBOLO)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setGenome(genome -> genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_LARGEST))).addMutations(mutations -> mutations.add(ForestryTreeSpecies.DESERT_ACACIA, ForestryTreeSpecies.DARK_OAK, 10))).setRarity(5.0E-4f);
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.WENGE, "millettia", "laurentii", true, new Color(11379031), ForestryWoodType.WENGE).setTreeFeature(FeatureWenge::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.WENGE)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.WENGE)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.WENGE)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).setGenome(genome -> {
            genome.set(TreeChromosomes.SAPLINGS, ForestryAlleles.SAPLINGS_LOWEST);
            genome.set(TreeChromosomes.GIRTH, ForestryAlleles.GIRTH_2);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.COCOBOLO, ForestryTreeSpecies.BALSA, 10))).setRarity(5.0E-4f);
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.BAOBAB, "adansonia", "digitata", true, new Color(0xFEFF8F), ForestryWoodType.BAOBAB).setTreeFeature(FeatureBaobab::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.BAOBAB)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.BAOBAB)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.BAOBAB)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).setGenome(genome -> {
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_LARGE);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOWER);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_SLOW);
            genome.set(TreeChromosomes.GIRTH, ForestryAlleles.GIRTH_3);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.BALSA, ForestryTreeSpecies.WENGE, 10))).setRarity(0.005f);
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.MAHOE, "talipariti", "elatum", true, new Color(10533403), ForestryWoodType.MAHOE).setTreeFeature(FeatureMahoe::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.MAHOE)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.MAHOE)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.MAHOE)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setGenome(genome -> {
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_SMALL);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_HIGH);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_SLOWEST);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.BALSA, ForestryTreeSpecies.DESERT_ACACIA, 5))).setRarity(5.0E-6f);
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.WILLOW, "salix", "alba", true, new Color(10729637), ForestryWoodType.WILLOW).setTreeFeature(FeatureWillow::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.WILLOW)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.WILLOW)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.WILLOW)).block()).m_49965_().m_61056_()).setHumidity(HumidityType.DAMP)).setGenome(genome -> {
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_AVERAGE);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOW);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_FASTER);
        })).addMutations(mutations -> {
            mutations.add(ForestryTreeSpecies.OAK, ForestryTreeSpecies.BIRCH, 10).restrictTemperature(TemperatureType.WARM, TemperatureType.HOT).restrictHumidity(HumidityType.DAMP);
            mutations.add(ForestryTreeSpecies.OAK, ForestryTreeSpecies.LIME, 10).restrictTemperature(TemperatureType.WARM, TemperatureType.HOT).restrictHumidity(HumidityType.DAMP);
            mutations.add(ForestryTreeSpecies.LIME, ForestryTreeSpecies.BIRCH, 10).restrictTemperature(TemperatureType.WARM, TemperatureType.HOT).restrictHumidity(HumidityType.DAMP);
        })).setRarity(0.0025f);
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.SIPIRI, "chlorocardium", "rodiei", true, new Color(6785297), ForestryWoodType.GREENHEART).setTreeFeature(FeatureGreenheart::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.SIPIRI)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.SIPIRI)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.SIPIRI)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).setGenome(genome -> {
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_LARGE);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOW);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_SLOW);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.KAPOK, ForestryTreeSpecies.MAHOGANY, 10).restrictTemperature(TemperatureType.WARM, TemperatureType.HOT).restrictHumidity(HumidityType.DAMP))).setRarity(0.0025f);
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.PAPAYA, "carica", "papaya", true, new Color(7184216), ForestryWoodType.PAPAYA).setTreeFeature(FeaturePapaya::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.PAPAYA)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.PAPAYA)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.PAPAYA)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).setGenome(genome -> {
            genome.set(TreeChromosomes.FRUIT, ForestryAlleles.FRUIT_PAPAYA);
            genome.set(TreeChromosomes.SAPLINGS, ForestryAlleles.SAPLINGS_LOW);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOWER);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_AVERAGE);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.JUNGLE, ForestryTreeSpecies.CHERRY, 5))).setRarity(0.005f);
        ((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.DATE, "phoenix", "dactylifera", true, new Color(13356409), ForestryWoodType.PALM).setTreeFeature(FeatureDate::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.DATE)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.DATE)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.DATE)).block()).m_49965_().m_61056_()).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).setGenome(genome -> {
            genome.set(TreeChromosomes.FRUIT, ForestryAlleles.FRUIT_DATES);
            genome.set(TreeChromosomes.SAPLINGS, ForestryAlleles.SAPLINGS_LOW);
            genome.set(TreeChromosomes.YIELD, ForestryAlleles.YIELD_LOW);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOW);
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_AVERAGE);
        })).addMutations(mutations -> mutations.add(ForestryTreeSpecies.JUNGLE, ForestryTreeSpecies.PAPAYA, 5))).setRarity(0.005f);
        ((ITreeSpeciesBuilder)arboriculture.registerSpecies(ForestryTreeSpecies.POPLAR, "populus", "alba", true, new Color(10729637), ForestryWoodType.POPLAR).setTreeFeature(FeaturePoplar::new).setDecorativeLeaves(ArboricultureBlocks.LEAVES_DECORATIVE.stack(ForestryLeafType.POPLAR)).addVanillaStates((Collection<BlockState>)((BlockDefaultLeaves)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(ForestryLeafType.POPLAR)).block()).m_49965_().m_61056_()).addVanillaStates((Collection<BlockState>)((BlockDefaultLeavesFruit)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(ForestryLeafType.POPLAR)).block()).m_49965_().m_61056_()).setGenome(genome -> {
            genome.set(TreeChromosomes.HEIGHT, ForestryAlleles.HEIGHT_SMALL);
            genome.set(TreeChromosomes.SAPPINESS, ForestryAlleles.SAPPINESS_LOW);
            genome.set(TreeChromosomes.MATURATION, ForestryAlleles.MATURATION_SLOWER);
        })).addMutations(mutations -> {
            mutations.add(ForestryTreeSpecies.BIRCH, ForestryTreeSpecies.WILLOW, 5);
            mutations.add(ForestryTreeSpecies.OAK, ForestryTreeSpecies.WILLOW, 5);
            mutations.add(ForestryTreeSpecies.LIME, ForestryTreeSpecies.WILLOW, 5);
        });
    }
}

