/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting;

import forestry.api.IForestryApi;
import forestry.api.core.ILocationProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.alleles.IAlleleManager;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.genetics.filter.FilterData;
import forestry.api.genetics.filter.IFilterLogic;
import forestry.api.genetics.filter.IFilterRuleType;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SpeciesUtil;
import forestry.sorting.AlleleFilter;
import forestry.sorting.DefaultFilterRuleType;
import forestry.sorting.network.packets.PacketFilterChangeGenome;
import forestry.sorting.network.packets.PacketFilterChangeRule;
import forestry.sorting.network.packets.PacketGuiFilterUpdate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class FilterLogic
implements IFilterLogic {
    private final ILocationProvider locatable;
    private final IFilterLogic.INetworkHandler networkHandler;
    private IFilterRuleType[] filterRules = new IFilterRuleType[6];
    private AlleleFilter[][] genomeFilter = new AlleleFilter[6][3];

    public FilterLogic(ILocationProvider locatable, IFilterLogic.INetworkHandler networkHandler) {
        this.locatable = locatable;
        this.networkHandler = networkHandler;
        for (int i = 0; i < this.filterRules.length; ++i) {
            this.filterRules[i] = IForestryApi.INSTANCE.getFilterManager().getDefaultRule();
        }
    }

    @Override
    public IFilterLogic.INetworkHandler getNetworkHandler() {
        return this.networkHandler;
    }

    @Override
    public CompoundTag write(CompoundTag data) {
        int i;
        for (i = 0; i < this.filterRules.length; ++i) {
            data.m_128359_("TypeFilter" + i, this.filterRules[i].getId());
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                AlleleFilter filter = this.genomeFilter[i][j];
                if (filter == null) continue;
                if (filter.activeSpecies != null) {
                    data.m_128359_("GenomeFilterS" + i + "-" + j + "-0", filter.activeSpecies.id().toString());
                }
                if (filter.inactiveSpecies == null) continue;
                data.m_128359_("GenomeFilterS" + i + "-" + j + "-1", filter.inactiveSpecies.id().toString());
            }
        }
        return data;
    }

    @Override
    public void read(CompoundTag data) {
        int i;
        for (i = 0; i < this.filterRules.length; ++i) {
            this.filterRules[i] = IForestryApi.INSTANCE.getFilterManager().getRuleOrDefault(data.m_128461_("TypeFilter" + i));
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                AlleleFilter filter = new AlleleFilter();
                if (data.m_128441_("GenomeFilterS" + i + "-" + j + "-0")) {
                    filter.activeSpecies = SpeciesUtil.getAnySpecies(new ResourceLocation(data.m_128461_("GenomeFilterS" + i + "-" + j + "-0")));
                }
                if (data.m_128441_("GenomeFilterS" + i + "-" + j + "-1")) {
                    filter.inactiveSpecies = SpeciesUtil.getAnySpecies(new ResourceLocation(data.m_128461_("GenomeFilterS" + i + "-" + j + "-1")));
                }
                this.genomeFilter[i][j] = filter;
            }
        }
    }

    @Override
    public void writeGuiData(FriendlyByteBuf buffer) {
        FilterLogic.writeFilterRules(buffer, this.filterRules);
        FilterLogic.writeGenomeFilters(buffer, this.genomeFilter);
    }

    @Override
    public void readGuiData(FriendlyByteBuf buffer) {
        this.filterRules = FilterLogic.readFilterRules(buffer);
        this.genomeFilter = FilterLogic.readGenomeFilters(buffer);
    }

    public static void writeFilterRules(FriendlyByteBuf buffer, IFilterRuleType[] filterRules) {
        for (IFilterRuleType filterRule : filterRules) {
            buffer.writeShort(IForestryApi.INSTANCE.getFilterManager().getId(filterRule));
        }
    }

    public static void writeGenomeFilters(FriendlyByteBuf buffer, AlleleFilter[][] genomeFilter) {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                AlleleFilter filter = genomeFilter[i][j];
                if (filter == null) {
                    buffer.writeBoolean(false);
                    buffer.writeBoolean(false);
                    continue;
                }
                if (filter.activeSpecies != null) {
                    buffer.writeBoolean(true);
                    buffer.m_130085_(filter.activeSpecies.id());
                } else {
                    buffer.writeBoolean(false);
                }
                if (filter.inactiveSpecies != null) {
                    buffer.writeBoolean(true);
                    buffer.m_130085_(filter.inactiveSpecies.id());
                    continue;
                }
                buffer.writeBoolean(false);
            }
        }
    }

    public static IFilterRuleType[] readFilterRules(FriendlyByteBuf buffer) {
        IFilterRuleType[] filterRules = new IFilterRuleType[6];
        for (int i = 0; i < 6; ++i) {
            filterRules[i] = IForestryApi.INSTANCE.getFilterManager().getRule(buffer.readShort());
        }
        return filterRules;
    }

    public static AlleleFilter[][] readGenomeFilters(FriendlyByteBuf buffer) {
        AlleleFilter[][] genomeFilters = new AlleleFilter[6][32023];
        IAlleleManager alleles = IForestryApi.INSTANCE.getAlleleManager();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                AlleleFilter filter = new AlleleFilter();
                if (buffer.readBoolean()) {
                    filter.activeSpecies = SpeciesUtil.getAnySpecies(buffer.m_130281_());
                }
                if (buffer.readBoolean()) {
                    filter.inactiveSpecies = SpeciesUtil.getAnySpecies(buffer.m_130281_());
                }
                genomeFilters[i][j] = filter;
            }
        }
        return genomeFilters;
    }

    @Override
    public boolean isValid(ItemStack stack, Direction facing) {
        return IIndividualHandlerItem.filter(stack, (individual, stage) -> this.isValid(facing, stack, new FilterData((IIndividual)individual, (ILifeStage)stage)));
    }

    @Override
    public boolean isValid(Direction facing, ItemStack stack, FilterData filterData) {
        IFilterRuleType rule = this.getRule(facing);
        if (rule == DefaultFilterRuleType.CLOSED) {
            return false;
        }
        if (rule == DefaultFilterRuleType.ITEM) {
            return true;
        }
        ResourceLocation requiredRoot = rule.getSpeciesTypeId();
        if (requiredRoot != null && !filterData.type().id().equals((Object)requiredRoot)) {
            return false;
        }
        if (rule == DefaultFilterRuleType.ANYTHING || rule.isValid(stack, filterData)) {
            IIndividual individual = filterData.individual();
            ISpecies<?> active = individual.getSpecies();
            ISpecies<?> inactive = individual.getInactiveSpecies();
            return this.isValidAllelePair(facing, active, inactive);
        }
        return false;
    }

    @Override
    public boolean isValidAllelePair(Direction orientation, ISpecies<?> active, ISpecies<?> inactive) {
        AlleleFilter[] directionFilters = this.genomeFilter[orientation.ordinal()];
        if (directionFilters == null) {
            return true;
        }
        boolean foundFilter = false;
        for (int i = 0; i < 3; ++i) {
            AlleleFilter filter = directionFilters[i];
            if (filter == null || filter.isEmpty()) continue;
            foundFilter = true;
            if (filter.isEmpty() || !filter.isValid(active, inactive)) continue;
            return true;
        }
        return !foundFilter;
    }

    @Override
    public IFilterRuleType getRule(Direction facing) {
        return this.filterRules[facing.ordinal()];
    }

    @Override
    public boolean setRule(Direction facing, IFilterRuleType rule) {
        if (this.filterRules[facing.ordinal()] != rule) {
            this.filterRules[facing.ordinal()] = rule;
            return true;
        }
        return false;
    }

    @Nullable
    public AlleleFilter getGenomeFilter(Direction facing, int index) {
        return this.genomeFilter[facing.ordinal()][index];
    }

    @Override
    @Nullable
    public ISpecies<?> getGenomeFilter(Direction facing, int index, boolean active) {
        AlleleFilter filter = this.getGenomeFilter(facing, index);
        if (filter == null) {
            return null;
        }
        return active ? filter.activeSpecies : filter.inactiveSpecies;
    }

    @Override
    public boolean setGenomeFilter(Direction facing, int index, boolean active, @Nullable ISpecies<?> allele) {
        boolean set;
        AlleleFilter filter = this.genomeFilter[facing.ordinal()][index];
        if (filter == null) {
            AlleleFilter alleleFilter = new AlleleFilter();
            this.genomeFilter[facing.ordinal()][index] = alleleFilter;
            filter = alleleFilter;
        }
        if (active) {
            set = filter.activeSpecies != allele;
            filter.activeSpecies = allele;
        } else {
            set = filter.inactiveSpecies != allele;
            filter.inactiveSpecies = allele;
        }
        return set;
    }

    @Override
    public void sendToServer(Direction facing, int index, boolean active, @Nullable ISpecies<?> allele) {
        NetworkUtil.sendToServer(new PacketFilterChangeGenome(this.locatable.getCoordinates(), facing, (short)index, active, allele));
    }

    @Override
    public void sendToServer(Direction facing, IFilterRuleType rule) {
        NetworkUtil.sendToServer(new PacketFilterChangeRule(this.locatable.getCoordinates(), facing, rule));
    }

    public PacketGuiFilterUpdate createGuiUpdatePacket(BlockPos pos) {
        return new PacketGuiFilterUpdate(pos, this.filterRules, this.genomeFilter);
    }

    public void readGuiUpdatePacket(PacketGuiFilterUpdate msg) {
        this.filterRules = msg.filterRules();
        this.genomeFilter = msg.genomeFilter();
    }
}

